# How the Incremental Matcher works

## Brainstorming

### Requirements

- Add haystacks on the fly
  - Ability to flush the matcher for new matches (poll-based)
  - OR
  - Ability to listen for new matches (push-based)
- Prefiltering
  - Incrementally would be a huge plus (post-mvp)
- Smith waterman
  - Incremental score matrix
  - Incremental alignment (post-mvp)

### Idea

#### Init

1. Group haystacks by length into buckets
   - Always copy strings into fixed-length `[u8; W]` arrays
2. Store haystacks with fixed-length `[u8; W]` arrays as `Haystack<W>`
  - `{ data: [u8; W], filtered_at: u16 }`
3. Interleave groups of `L` haystacks into `HaystackSimd<W, L>`

```rs
struct HaystackSimd<W, L> {
  data: [[u8; W]; L],
  filtered_at: [u16; L],

  indices: [u16; L],
  length: u16,

  simd: [HaystackChar<u16, L>; W],
  score_matrix: Vec<Simd<u16, L>>,
  score: [u16; L],
}
```

#### Match

1. For `filtered_at[i] > prefix_to_keep`, run prefiltering step and update `filtered_at[i]` accordingly
2. 
