/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public abstract class Bounds
implements Cloneable {
    static final double EPSILON = 1.0E-6;
    static final boolean debug = false;
    static final int BOUNDING_BOX = 1;
    static final int BOUNDING_SPHERE = 2;
    static final int BOUNDING_POLYTOPE = 4;
    boolean boundsIsEmpty = false;
    boolean boundsIsInfinite = false;
    int boundId = 0;

    public abstract Object clone();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract boolean intersect(Point3d var1, Vector3d var2);

    public abstract boolean intersect(Point3d var1);

    abstract boolean intersect(Point3d var1, Vector3d var2, Point4d var3);

    abstract boolean intersect(Point3d var1, Point4d var2);

    abstract boolean intersect(Point3d var1, Point3d var2, Point4d var3);

    abstract boolean intersect(Bounds var1, Point4d var2);

    public abstract boolean intersect(Bounds var1);

    public abstract boolean intersect(Bounds[] var1);

    public abstract Bounds closestIntersection(Bounds[] var1);

    abstract Point3d getCenter();

    public abstract void combine(Bounds var1);

    public abstract void combine(Bounds[] var1);

    public abstract void combine(Point3d var1);

    public abstract void combine(Point3d[] var1);

    public abstract void transform(Transform3D var1);

    public abstract void transform(Bounds var1, Transform3D var2);

    public abstract boolean isEmpty();

    public abstract void set(Bounds var1);

    abstract Bounds copy(Bounds var1);

    private void test_point(Vector4d[] vector4dArray, Point3d point3d) {
        for (int i = 0; i < vector4dArray.length; ++i) {
            double d = point3d.x * vector4dArray[i].x + point3d.y * vector4dArray[i].y + point3d.z * vector4dArray[i].z + vector4dArray[i].w;
            if (!(d > 1.0E-6)) continue;
            System.err.println("new point is outside of plane[" + i + "] dist = " + d);
        }
    }

    boolean closest_point(Point3d point3d, Vector4d[] vector4dArray, Point3d point3d2) {
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        Object var74_6 = null;
        Matrix3d matrix3d = new Matrix3d();
        double d = 1.0E8;
        int n = 0;
        point3d4.set((Tuple3d)point3d);
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        while (!bl) {
            double d2;
            double d3;
            boolean bl4 = true;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            for (int i = 0; i < vector4dArray.length; ++i) {
                Vector4d vector4d = vector4dArray[i];
                d3 = point3d4.x * vector4d.x + point3d4.y * vector4d.y + point3d4.z * vector4d.z + vector4d.w;
                if (d3 > -1.0E-6) {
                    d4 += vector4d.x * vector4d.x;
                    d5 += vector4d.y * vector4d.y;
                    d6 += vector4d.z * vector4d.z;
                    d7 += vector4d.x * vector4d.y;
                    d8 += vector4d.x * vector4d.z;
                    d9 += vector4d.y * vector4d.z;
                    d10 += vector4d.x * vector4d.w;
                    d11 += vector4d.y * vector4d.w;
                    d12 += vector4d.z * vector4d.w;
                }
                if (!(d3 > 1.0E-6)) continue;
                bl4 = false;
            }
            if (bl4) {
                if (bl2) {
                    bl3 = true;
                }
                point3d2.set((Tuple3d)point3d4);
                bl = true;
                continue;
            }
            bl2 = false;
            double d13 = 1.0 + d4 * d;
            double d14 = d7 * d;
            double d15 = d8 * d;
            double d16 = 1.0 + d5 * d;
            double d17 = d9 * d;
            double d18 = 1.0 + d6 * d;
            double d19 = point3d.x - d * d10;
            double d20 = point3d.y - d * d11;
            double d21 = point3d.z - d * d12;
            double d22 = 1.0 / d13;
            double d23 = d22 * d14;
            double d24 = d22 * d15;
            double d25 = d16 - d23 * d14;
            double d26 = 1.0 / d25;
            double d27 = d17 - d14 * d24;
            double d28 = d26 * d27;
            double d29 = 1.0 / (d18 - d15 * d24 - d27 * d28);
            double d30 = d22 * d19;
            double d31 = d26 * (d20 - d14 * d30);
            point3d3.z = d2 = d29 * (d21 - d15 * d30 - d27 * d31);
            point3d3.y = d31 - d28 * point3d3.z;
            point3d3.x = d30 - d24 * point3d3.z - d23 * point3d3.y;
            d3 = (point3d4.x - point3d3.x) * (point3d4.x - point3d3.x) + (point3d4.y - point3d3.y) * (point3d4.y - point3d3.y) + (point3d4.z - point3d3.z) * (point3d4.z - point3d3.z);
            if (d3 < 1.0E-6) {
                bl = true;
                point3d2.set((Tuple3d)point3d3);
                continue;
            }
            point3d4.set((Tuple3d)point3d3);
            if (++n <= 4) continue;
            point3d2.set((Tuple3d)point3d3);
            bl = true;
        }
        return bl3;
    }

    boolean intersect_ptope_sphere(BoundingPolytope boundingPolytope, BoundingSphere boundingSphere) {
        Point3d point3d = new Point3d();
        boolean bl = this.closest_point(boundingSphere.center, boundingPolytope.planes, point3d);
        if (!bl) {
            return !(point3d.distanceSquared(boundingSphere.center) > boundingSphere.radius * boundingSphere.radius);
        }
        return true;
    }

    boolean intersect_ptope_abox(BoundingPolytope boundingPolytope, BoundingBox boundingBox) {
        Vector4d[] vector4dArray = new Vector4d[]{new Vector4d(-1.0, 0.0, 0.0, boundingBox.lower.x), new Vector4d(1.0, 0.0, 0.0, -boundingBox.upper.x), new Vector4d(0.0, -1.0, 0.0, boundingBox.lower.y), new Vector4d(0.0, 1.0, 0.0, -boundingBox.upper.y), new Vector4d(0.0, 0.0, -1.0, boundingBox.lower.z), new Vector4d(0.0, 0.0, 1.0, -boundingBox.upper.z)};
        BoundingPolytope boundingPolytope2 = new BoundingPolytope(vector4dArray);
        boolean bl = this.intersect_ptope_ptope(boundingPolytope, boundingPolytope2);
        return bl;
    }

    boolean intersect_ptope_ptope(BoundingPolytope boundingPolytope, BoundingPolytope boundingPolytope2) {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        boolean bl = false;
        point3d.x = 0.0;
        point3d.y = 0.0;
        point3d.z = 0.0;
        this.closest_point(point3d, boundingPolytope.planes, point3d2);
        bl = this.closest_point(point3d2, boundingPolytope2.planes, point3d);
        if (bl) {
            return true;
        }
        bl = this.closest_point(point3d, boundingPolytope.planes, point3d3);
        double d = point3d.distanceSquared(point3d2);
        while (!bl) {
            double d2 = point3d.distanceSquared(point3d3);
            if (!(d2 < d)) {
                point3d2.set((Tuple3d)point3d3);
                break;
            }
            point3d2.set((Tuple3d)point3d3);
            bl = this.closest_point(point3d2, boundingPolytope2.planes, point3d4);
            d = d2;
            d2 = point3d4.distanceSquared(point3d2);
            if (d2 < d) {
                point3d.set((Tuple3d)point3d4);
                if (!bl) {
                    bl = this.closest_point(point3d, boundingPolytope.planes, point3d3);
                }
            } else {
                point3d.set((Tuple3d)point3d4);
                break;
            }
            d = d2;
        }
        return bl;
    }

    synchronized void setWithLock(Bounds bounds) {
        this.set(bounds);
    }

    synchronized void getWithLock(Bounds bounds) {
        bounds.set(this);
    }

    abstract int getPickType();
}

