/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Report;
import megamek.common.TargetRoll;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlasmaRifleHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = -2092721653693187140L;

    public PlasmaRifleHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.generalDamageType = -3;
    }

    @Override
    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        super.handleEntityDamage(entity, vector, building, n, n2, n3, n4);
        if (!this.missed && entity instanceof Mech) {
            this.r = new Report(3400);
            this.r.subject = this.subjectId;
            this.r.indent(2);
            int n5 = Compute.d6();
            this.r.add(n5);
            this.r.choose(true);
            this.r.newlines = 0;
            vector.addElement(this.r);
            entity.heatFromExternal += n5;
        }
    }

    @Override
    protected int calcDamagePerHit() {
        if (this.target instanceof Mech) {
            int n = 10;
            if (this.bGlancing) {
                n = (int)Math.floor((double)n / 2.0);
            }
            if (this.game.getOptions().booleanOption("tacops_range") && this.nRange > this.wtype.getRanges(this.weapon)[3]) {
                n = (int)Math.floor((double)n / 2.0);
                --n;
            }
            return n;
        }
        return 1;
    }

    @Override
    protected int calcnCluster() {
        if (this.target instanceof Mech) {
            this.bSalvo = false;
            return 1;
        }
        int n = 5;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            n = Compute.d6(2);
        }
        this.bSalvo = true;
        if (this.target instanceof Infantry && ((Entity)this.target).getCrew().getOptions().booleanOption("pain_shunt")) {
            n = Math.max(n / 2, 1);
        }
        return n;
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n;
        if (this.target instanceof Mech) {
            n = 1;
        } else {
            n = this.target instanceof BattleArmor && ((BattleArmor)this.target).isFireResistant() ? 5 : 10 + Compute.d6(2);
            if (this.bGlancing) {
                n = (int)Math.floor((double)n / 2.0);
            }
        }
        return n;
    }

    @Override
    protected boolean handleSpecialMiss(Entity entity, boolean bl, Building building, Vector<Report> vector) {
        if (entity != null && building == null && this.wtype.getFireTN() != Integer.MAX_VALUE) {
            this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, true, false, new TargetRoll(this.wtype.getFireTN(), this.wtype.getName()), 3, vector);
        }
        this.server.checkExplodeIndustrialZone(this.target.getPosition(), vector);
        return bl && this.toHit.getValue() != 0x7FFFFFFE;
    }

    @Override
    protected void handleIgnitionDamage(Vector<Report> vector, Building building, boolean bl, int n) {
        TargetRoll targetRoll;
        if (!bl) {
            this.r = new Report(2270);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        if ((targetRoll = new TargetRoll(this.wtype.getFireTN(), this.wtype.getName())).getValue() != Integer.MAX_VALUE) {
            Report.addNewline(vector);
            this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, true, false, targetRoll, true, -1, vector);
        }
    }

    @Override
    protected void handleClearDamage(Vector<Report> vector, Building building, int n, boolean bl) {
        if (!bl) {
            this.r = new Report(2270);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        this.r = new Report(3385);
        this.r.indent();
        this.r.subject = this.subjectId;
        this.r.add(n);
        vector.addElement(this.r);
        if (building != null && this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, true, false, new TargetRoll(this.wtype.getFireTN(), this.wtype.getName()), 5, vector)) {
            return;
        }
        vector.addAll(this.server.tryClearHex(this.target.getPosition(), n, this.subjectId));
    }
}

