/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.Aero;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Dropship;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Jumpship;
import megamek.common.Mech;
import megamek.common.Messages;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.VTOL;

public class PlanetaryConditions
implements Serializable {
    private static final long serialVersionUID = 6838624193286089781L;
    public static final int L_DAY = 0;
    public static final int L_DUSK = 1;
    public static final int L_FULL_MOON = 2;
    public static final int L_MOONLESS = 3;
    public static final int L_PITCH_BLACK = 4;
    private static String[] lightNames = new String[]{"Daylight", "Dusk", "Full Moon Night", "Moonless Night", "Pitch Black"};
    public static final int L_SIZE = lightNames.length;
    public static final int WE_NONE = 0;
    public static final int WE_LIGHT_RAIN = 1;
    public static final int WE_MOD_RAIN = 2;
    public static final int WE_HEAVY_RAIN = 3;
    public static final int WE_DOWNPOUR = 4;
    public static final int WE_LIGHT_SNOW = 5;
    public static final int WE_MOD_SNOW = 6;
    public static final int WE_HEAVY_SNOW = 7;
    public static final int WE_SLEET = 8;
    public static final int WE_ICE_STORM = 9;
    public static final int WE_LIGHT_HAIL = 10;
    public static final int WE_HEAVY_HAIL = 11;
    private static String[] weatherNames = new String[]{"Clear", "Light Rain", "Moderate Rain", "Heavy Rain", "Torrential Downpour", "Light Snowfall", "Moderate Snowfall", "Heavy Snowfall", "Sleet", "Ice Storm"};
    public static final int WE_SIZE = weatherNames.length;
    public static final int WI_NONE = 0;
    public static final int WI_LIGHT_GALE = 1;
    public static final int WI_MOD_GALE = 2;
    public static final int WI_STRONG_GALE = 3;
    public static final int WI_STORM = 4;
    public static final int WI_TORNADO_F13 = 5;
    public static final int WI_TORNADO_F4 = 6;
    private static String[] windNames = new String[]{"Calm", "Light Gale", "Moderate Gale", "Strong Gale", "Storm", "Tornado F1-F3", "Tornado F4"};
    public static final int WI_SIZE = windNames.length;
    private static String[] dirNames = new String[]{"North", "Northeast", "Southeast", "South", "Southwest", "Northwest"};
    public static final int DIR_SIZE = dirNames.length;
    public static final int ATMO_VACUUM = 0;
    public static final int ATMO_TRACE = 1;
    public static final int ATMO_THIN = 2;
    public static final int ATMO_STANDARD = 3;
    public static final int ATMO_HIGH = 4;
    public static final int ATMO_VHIGH = 5;
    public static String[] atmoNames = new String[]{"Vacuum", "Trace", "Thin", "Standard", "High", "Very High"};
    public static final int ATMO_SIZE = atmoNames.length;
    public static final int FOG_NONE = 0;
    public static final int FOG_LIGHT = 1;
    public static final int FOG_HEAVY = 2;
    private static String[] fogNames = new String[]{"None", "Light Fog", "Heavy Fog"};
    public static final int FOG_SIZE = fogNames.length;
    private boolean blowingSand = false;
    private int lightConditions = 0;
    private int weatherConditions = 0;
    private int windStrength = 0;
    private int windDirection = -1;
    private boolean shiftWindDirection = false;
    private boolean shiftWindStrength = false;
    private int atmosphere = 3;
    private int fog = 0;
    private int temperature = 25;
    private float gravity = 1.0f;
    private boolean emi = false;
    private boolean terrainAffected = true;
    private int maxWindStrength = 6;

    public PlanetaryConditions() {
    }

    public PlanetaryConditions(PlanetaryConditions planetaryConditions) {
        this.lightConditions = planetaryConditions.lightConditions;
        this.weatherConditions = planetaryConditions.weatherConditions;
        this.windStrength = planetaryConditions.windStrength;
        this.windDirection = planetaryConditions.windDirection;
        this.shiftWindDirection = planetaryConditions.shiftWindDirection;
        this.shiftWindStrength = planetaryConditions.shiftWindStrength;
        this.atmosphere = planetaryConditions.atmosphere;
        this.temperature = planetaryConditions.temperature;
        this.gravity = planetaryConditions.gravity;
        this.emi = planetaryConditions.emi;
        this.fog = planetaryConditions.fog;
        this.terrainAffected = planetaryConditions.terrainAffected;
    }

    public Object clone() {
        return new PlanetaryConditions(this);
    }

    public static String getLightDisplayableName(int n) {
        if (n >= 0 && n < L_SIZE) {
            return Messages.getString("PlanetaryConditions." + lightNames[n]);
        }
        throw new IllegalArgumentException("Unknown light condition");
    }

    public static String getWeatherDisplayableName(int n) {
        if (n >= 0 && n < WE_SIZE) {
            return Messages.getString("PlanetaryConditions." + weatherNames[n]);
        }
        throw new IllegalArgumentException("Unknown weather condition");
    }

    public static String getWindDisplayableName(int n) {
        if (n >= 0 && n < WI_SIZE) {
            return Messages.getString("PlanetaryConditions." + windNames[n]);
        }
        throw new IllegalArgumentException("Unknown wind condition");
    }

    public static String getAtmosphereDisplayableName(int n) {
        if (n >= 0 && n < ATMO_SIZE) {
            return Messages.getString("PlanetaryConditions." + atmoNames[n]);
        }
        throw new IllegalArgumentException("Unknown atmospheric pressure condition");
    }

    public static String getFogDisplayableName(int n) {
        if (n >= 0 && n < FOG_SIZE) {
            return Messages.getString("PlanetaryConditions." + fogNames[n]);
        }
        throw new IllegalArgumentException("Unknown fog condition");
    }

    public String getWindDirName() {
        return dirNames[this.windDirection];
    }

    public String getLightCurrentName() {
        return Messages.getString("PlanetaryConditions." + lightNames[this.lightConditions]);
    }

    public String getWeatherCurrentName() {
        return Messages.getString("PlanetaryConditions." + weatherNames[this.weatherConditions]);
    }

    public String getWindCurrentName() {
        return Messages.getString("PlanetaryConditions." + windNames[this.windStrength]);
    }

    public String getAtmosphereCurrentName() {
        return Messages.getString("PlanetaryConditions." + atmoNames[this.atmosphere]);
    }

    public String getFogCurrentName() {
        return Messages.getString("PlanetaryConditions." + fogNames[this.fog]);
    }

    public int getLightHitPenalty(boolean bl) {
        int n = 0;
        if (bl) {
            if (this.lightConditions == 1) {
                n = 1;
            } else if (this.lightConditions == 2) {
                n = 2;
            } else if (this.lightConditions == 3) {
                n = 3;
            } else if (this.lightConditions == 4) {
                n = 4;
            }
        } else if (this.lightConditions == 3) {
            n = 1;
        } else if (this.lightConditions == 4) {
            n = 2;
        }
        return n;
    }

    public int getLightHeatBonus(int n) {
        double d = 10000.0;
        if (this.lightConditions == 1) {
            d = 25.0;
        } else if (this.lightConditions == 2) {
            d = 20.0;
        } else if (this.lightConditions == 3) {
            d = 15.0;
        } else if (this.lightConditions == 4) {
            d = 10.0;
        }
        return -1 * (int)Math.floor((double)n / d);
    }

    public int getLightPilotPenalty() {
        if (this.lightConditions == 3) {
            return 1;
        }
        if (this.lightConditions == 4) {
            return 2;
        }
        return 0;
    }

    public int getWeatherHitPenalty(Entity entity) {
        if ((this.weatherConditions == 1 || this.weatherConditions == 5) && entity instanceof Infantry && !(entity instanceof BattleArmor)) {
            return 1;
        }
        if (this.weatherConditions == 2 || this.weatherConditions == 3 || this.weatherConditions == 6 || this.weatherConditions == 7 || this.weatherConditions == 8) {
            return 1;
        }
        if (this.weatherConditions == 4) {
            return 2;
        }
        return 0;
    }

    public int getWeatherPilotPenalty() {
        if (this.weatherConditions == 3 || this.weatherConditions == 7) {
            return 1;
        }
        if (this.weatherConditions == 4) {
            return 2;
        }
        return 0;
    }

    public int getGravityPilotPenalty() {
        return (int)Math.ceil(Math.abs((double)this.gravity - 1.0) / 0.5);
    }

    public int getWindPilotPenalty(Entity entity) {
        int n = 0;
        switch (this.windStrength) {
            case 2: {
                if (!(entity instanceof VTOL) && entity.getMovementMode() != 15) break;
                n = 1;
                break;
            }
            case 3: {
                if (entity instanceof VTOL || entity.getMovementMode() == 15 || entity.getMovementMode() == 5) {
                    n = 2;
                    break;
                }
                if (!(entity instanceof Mech) && !(entity instanceof Aero)) break;
                n = 1;
                break;
            }
            case 4: {
                if (entity instanceof VTOL || entity instanceof Mech || entity.getMovementMode() == 15 || entity.getMovementMode() == 5) {
                    n = 3;
                    break;
                }
                if (!(entity instanceof Aero)) break;
                n = 2;
                break;
            }
            case 5: {
                n = 3;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public void determineWind() {
        if (this.windDirection == -1) {
            this.windDirection = Compute.d6(1) - 1;
        } else if (this.shiftWindDirection) {
            switch (Compute.d6()) {
                case 1: {
                    this.windDirection = (this.windDirection + 1) % 6;
                    break;
                }
                case 6: {
                    this.windDirection = (this.windDirection + 5) % 6;
                }
            }
        }
        if (this.shiftWindStrength) {
            switch (Compute.d6()) {
                case 1: {
                    this.windStrength = Math.max(0, --this.windStrength);
                    break;
                }
                case 6: {
                    this.windStrength = Math.min(this.maxWindStrength, ++this.windStrength);
                }
            }
        }
        if (this.atmosphere == 1 && this.windStrength > 4) {
            this.windStrength = 4;
        }
        if (this.atmosphere == 2 && this.windStrength > 5) {
            this.windStrength = 5;
        }
    }

    public int getIgniteModifiers() {
        int n = 0;
        if (this.weatherConditions == 1 || this.weatherConditions == 2) {
            ++n;
        }
        if (this.weatherConditions == 3 || this.weatherConditions == 4 || this.weatherConditions == 5 || this.weatherConditions == 6) {
            n += 2;
        }
        if (this.weatherConditions == 7 || this.weatherConditions == 10 || this.weatherConditions == 11) {
            n += 3;
        }
        if (this.windStrength == 1 || this.windStrength == 2) {
            n += 2;
        }
        if (this.windStrength == 3 || this.windStrength == 4 || this.weatherConditions == 9) {
            n += 4;
        }
        return n += this.getTemperatureDifference(30, -30);
    }

    public boolean putOutFire() {
        int n = Compute.d6(2);
        switch (this.weatherConditions) {
            case 1: 
            case 5: 
            case 10: {
                ++n;
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                n += 2;
                break;
            }
            case 3: 
            case 7: {
                n += 3;
                break;
            }
            case 4: {
                n += 4;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n > 10;
    }

    public int getTemperatureDifference(int n, int n2) {
        int n3 = 0;
        if (n2 > n) {
            int n4 = n2;
            n2 = n;
            n = n4;
        }
        if (this.getTemperature() >= n2 && this.getTemperature() <= n) {
            return n3;
        }
        if (this.getTemperature() < n2) {
            while (this.getTemperature() + ++n3 * 10 < n2) {
            }
            return n3;
        }
        while (this.getTemperature() - ++n3 * 10 > n) {
        }
        return n3;
    }

    public String cannotStartFire() {
        if (this.atmosphere < 2) {
            return "atmosphere this thin";
        }
        if (this.windStrength > 4) {
            return "a tornado";
        }
        return null;
    }

    public int getMovementMods(Entity entity) {
        int n = 0;
        switch (this.windStrength) {
            case 1: {
                if (entity instanceof BattleArmor || entity.getMovementMode() != 10 && entity.getMovementMode() != 12) break;
                --n;
                break;
            }
            case 2: {
                if (!(entity instanceof Infantry) || entity instanceof BattleArmor) break;
                --n;
                break;
            }
            case 3: 
            case 4: {
                if (entity instanceof BattleArmor) {
                    --n;
                    break;
                }
                if (!(entity instanceof Infantry)) break;
                n -= 2;
                break;
            }
            case 5: {
                if (entity instanceof Aero) {
                    --n;
                    break;
                }
                n -= 2;
            }
        }
        switch (this.weatherConditions) {
            case 5: {
                if ((!(entity instanceof Infantry) || entity instanceof BattleArmor) && !(entity instanceof Tank)) break;
                --n;
                break;
            }
            case 6: {
                if ((!(entity instanceof Infantry) || entity instanceof BattleArmor) && !(entity instanceof Tank)) break;
                n -= 2;
                break;
            }
            case 7: {
                if ((!(entity instanceof Infantry) || entity instanceof BattleArmor) && !(entity instanceof Tank)) break;
                n -= 3;
            }
        }
        switch (this.atmosphere) {
            case 2: {
                if (entity.getMovementMode() != 5 && entity.getMovementMode() != 15 && entity.getMovementMode() != 6) break;
                n -= 2;
                break;
            }
            case 4: 
            case 5: {
                if (entity.getMovementMode() != 5 && entity.getMovementMode() != 15 && entity.getMovementMode() != 6) break;
                ++n;
            }
        }
        if (entity instanceof Tank || entity instanceof Infantry || entity instanceof Protomech) {
            n -= Math.abs(this.getTemperatureDifference(50, -30));
        }
        return n;
    }

    public String whyDoomed(Entity entity) {
        if (this.atmosphere < 2 && entity.doomedInVacuum()) {
            return "vacuum";
        }
        if (this.windStrength == 6 && !(entity instanceof Mech)) {
            return "tornado";
        }
        if (this.windStrength == 5 && (entity instanceof Infantry && !(entity instanceof BattleArmor) || entity.getMovementMode() == 5 || entity.getMovementMode() == 15 || entity.getMovementMode() == 6)) {
            return "tornado";
        }
        if (this.windStrength == 4 && entity instanceof Infantry && !(entity instanceof BattleArmor)) {
            return "storm";
        }
        return null;
    }

    public int getVisualRange(Entity entity, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (entity == null) {
            bl3 = true;
            bl2 = bl;
        } else {
            bl2 = entity.isUsingSpotlight();
            bl3 = entity instanceof Mech || entity instanceof Tank;
            bl4 = entity instanceof Dropship || entity instanceof Jumpship;
            boolean bl6 = bl5 = entity instanceof Aero && !bl4;
        }
        if (this.lightConditions == 4 && !bl2 && !bl) {
            if (bl3) {
                return 3;
            }
            if (bl5) {
                return 5;
            }
            if (bl4) {
                return 4;
            }
            return 1;
        }
        if (this.lightConditions == 3 && !bl2 && !bl || this.lightConditions == 2 && !bl2 && !bl || this.weatherConditions == 7 && this.windStrength >= 3) {
            if (bl3) {
                return 5;
            }
            if (bl5) {
                return 10;
            }
            if (bl4) {
                return 8;
            }
            return 2;
        }
        if (this.weatherConditions == 7 || this.weatherConditions == 3 || this.weatherConditions == 4 || this.weatherConditions == 8 || this.weatherConditions == 9 || this.weatherConditions == 11 || this.fog == 2 || this.blowingSand && this.windStrength >= 2) {
            if (bl3) {
                return 10;
            }
            if (bl5) {
                return 20;
            }
            if (bl4) {
                return 15;
            }
            return 5;
        }
        if (this.lightConditions == 4 && !bl) {
            if (bl3) {
                return 13;
            }
            if (bl5) {
                return 15;
            }
            if (bl4) {
                return 14;
            }
            return 6;
        }
        if (this.lightConditions > 0 && !bl2 && !bl || (this.weatherConditions == 7 || this.weatherConditions == 6) && this.windStrength >= 2) {
            if (bl3) {
                return 15;
            }
            if (bl5) {
                return 30;
            }
            if (bl4) {
                return 20;
            }
            return 8;
        }
        if (this.lightConditions > 0 && !bl) {
            if (bl3) {
                return 25;
            }
            if (bl5) {
                return 40;
            }
            if (bl4) {
                return 30;
            }
            return 13;
        }
        if (this.weatherConditions == 6 || this.weatherConditions == 2) {
            if (bl3) {
                return 20;
            }
            if (bl5) {
                return 50;
            }
            if (bl4) {
                return 25;
            }
            return 10;
        }
        if (this.lightConditions > 0 || this.weatherConditions == 5 || this.weatherConditions == 1 || this.weatherConditions == 10 || this.fog == 1) {
            if (bl3) {
                return 30;
            }
            if (bl5) {
                return 60;
            }
            if (bl4) {
                return 35;
            }
            return 15;
        }
        if (bl3) {
            return 60;
        }
        if (bl5) {
            return 120;
        }
        if (bl4) {
            return 70;
        }
        return 30;
    }

    public void setLight(int n) {
        this.lightConditions = n;
    }

    public int getLight() {
        return this.lightConditions;
    }

    public void setWeather(int n) {
        this.weatherConditions = n;
    }

    public int getWeather() {
        return this.weatherConditions;
    }

    public void setWindStrength(int n) {
        this.windStrength = n;
    }

    public int getWindStrength() {
        return this.windStrength;
    }

    public void setWindDirection(int n) {
        this.windDirection = n;
    }

    public int getWindDirection() {
        return this.windDirection;
    }

    public void setShiftingWindDirection(boolean bl) {
        this.shiftWindDirection = bl;
    }

    public boolean shiftingWindDirection() {
        return this.shiftWindDirection;
    }

    public void setShiftingWindStrength(boolean bl) {
        this.shiftWindStrength = bl;
    }

    public boolean shiftingWindStrength() {
        return this.shiftWindStrength;
    }

    public void setAtmosphere(int n) {
        this.atmosphere = n;
    }

    public int getAtmosphere() {
        return this.atmosphere;
    }

    public void setTemperature(int n) {
        this.temperature = n;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public boolean isVacuum() {
        return this.atmosphere == 0 || this.atmosphere == 1;
    }

    public void setGravity(float f) {
        this.gravity = f;
    }

    public float getGravity() {
        return this.gravity;
    }

    public void setEMI(boolean bl) {
        this.emi = bl;
    }

    public boolean hasEMI() {
        return this.emi;
    }

    public int getFog() {
        return this.fog;
    }

    public void setFog(int n) {
        this.fog = n;
    }

    public void setTerrainAffected(boolean bl) {
        this.terrainAffected = bl;
    }

    public boolean isTerrainAffected() {
        return this.terrainAffected;
    }

    public boolean isRecklessConditions() {
        return this.fog > 0 || this.lightConditions > 1;
    }

    public int getMaxWindStrength() {
        return this.maxWindStrength;
    }

    public void setMaxWindStrength(int n) {
        this.maxWindStrength = n;
    }

    public boolean isSandBlowing() {
        return this.blowingSand;
    }

    public void setBlowingSand(boolean bl) {
        this.blowingSand = bl;
    }
}

