/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import megamek.common.util.ItemFile;
import megamek.common.util.ItemFileFactory;

public class ImageFileFactory
implements ItemFileFactory {
    private static final String JPG = "JPG";
    private static final String JPEG = "JPEG";
    private static final String GIF = "GIF";
    private static final String PNG = "PNG";
    private static ImageFileFactory singleton = null;

    private ImageFileFactory() {
    }

    public static ImageFileFactory getInstance() {
        if (null == singleton) {
            singleton = new ImageFileFactory();
        }
        return singleton;
    }

    public ItemFile getItemFile(final File file) throws IllegalArgumentException {
        if (null == file) {
            throw new IllegalArgumentException("A null image file was passed.");
        }
        return new ItemFile(){
            private File itemFile;
            private Image image;
            {
                this.itemFile = file;
                this.image = null;
            }

            public Object getItem() throws Exception {
                if (null == this.image) {
                    String string = this.itemFile.getAbsolutePath();
                    this.image = Toolkit.getDefaultToolkit().getImage(string);
                }
                return this.image.getScaledInstance(84, 72, 2);
            }
        };
    }

    public ItemFile getItemFile(final ZipEntry zipEntry, final ZipFile zipFile) throws IllegalArgumentException {
        if (null == zipEntry) {
            throw new IllegalArgumentException("A null ZIP entry was passed.");
        }
        if (null == zipFile) {
            throw new IllegalArgumentException("A null ZIP file was passed.");
        }
        return new ItemFile(){
            private ZipEntry itemEntry;
            private Image image;
            {
                this.itemEntry = zipEntry;
                this.image = null;
            }

            public Object getItem() throws Exception {
                if (null == this.image) {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(this.itemEntry), (int)this.itemEntry.getSize());
                    byte[] byArray = new byte[(int)this.itemEntry.getSize()];
                    ((InputStream)bufferedInputStream).read(byArray);
                    int n = (int)this.itemEntry.getSize() - 10;
                    while (this.itemEntry.getSize() > (long)n && 0 == byArray[n]) {
                        ++n;
                    }
                    if (this.itemEntry.getSize() <= (long)n) {
                        throw new IOException("Error reading " + this.itemEntry.getName() + "\nYou may want to unzip " + zipFile.getName());
                    }
                    this.image = Toolkit.getDefaultToolkit().createImage(byArray);
                }
                return this.image.getScaledInstance(84, 72, 2);
            }
        };
    }

    public boolean accept(File file, String string) {
        String string2 = string.toUpperCase();
        return string2.endsWith(JPG) || string2.endsWith(JPEG) || string2.endsWith(GIF) || string2.endsWith(PNG);
    }

    public boolean accept(ZipFile zipFile, String string) {
        String string2 = string.toUpperCase();
        return string2.endsWith(JPG) || string2.endsWith(JPEG) || string2.endsWith(GIF) || string2.endsWith(PNG);
    }
}

