/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions.ruby20;

import org.jruby.RubyHash;
import org.jruby.RubySymbol;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveKeywordArgInstr
extends ReceiveArgBase {
    public final int numUsedArgs;

    public ReceiveKeywordArgInstr(Variable result2, int numUsedArgs) {
        super(Operation.RECV_KW_ARG, result2, -1);
        this.numUsedArgs = numUsedArgs;
    }

    @Override
    public String toString() {
        return (this.isDead() ? "[DEAD]" : "") + (this.hasUnusedResult() ? "[DEAD-RESULT]" : "") + this.getResult() + " = " + (Object)((Object)this.getOperation()) + "(" + this.numUsedArgs + ")";
    }

    public Object receiveKWArg(ThreadContext context, int kwArgHashCount, IRubyObject[] args2) {
        RubySymbol argName;
        if (kwArgHashCount == 0) {
            return UndefinedValue.UNDEFINED;
        }
        RubyHash lastArg = (RubyHash)args2[args2.length - 1];
        if (this.numUsedArgs == args2.length) {
            Arity.raiseArgumentError(context.getRuntime(), args2.length - 1, this.numUsedArgs, -1);
        }
        if (lastArg.fastARef(argName = context.getRuntime().newSymbol(this.getResult().getName())) != null) {
            return lastArg.delete(context, argName, Block.NULL_BLOCK);
        }
        return UndefinedValue.UNDEFINED;
    }
}

