/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubySymbol;
import org.jruby.ext.ffi.FFI;
import org.jruby.ext.ffi.Type;
import org.jruby.runtime.builtin.IRubyObject;

public final class TypeResolver {
    private final FFI ffi;
    private volatile Map<RubySymbol, Type> symbolTypeCache = Collections.emptyMap();

    TypeResolver(FFI ffi2) {
        this.ffi = ffi2;
    }

    public final Type findType(Ruby runtime, IRubyObject name2) {
        if (name2 instanceof Type) {
            return (Type)name2;
        }
        if (name2 instanceof RubySymbol) {
            return this.findType(runtime, (RubySymbol)name2);
        }
        return this.lookupType(runtime, name2);
    }

    public final Type findType(Ruby runtime, RubySymbol name2) {
        Object obj = name2.getFFIHandle();
        if (obj instanceof Type) {
            return (Type)obj;
        }
        Type type2 = this.symbolTypeCache.get(name2);
        if (type2 != null) {
            return type2;
        }
        return this.lookupAndCacheType(runtime, name2);
    }

    private synchronized Type lookupAndCacheType(Ruby runtime, RubySymbol name2) {
        Type type2 = this.lookupType(runtime, name2);
        IdentityHashMap<RubySymbol, Type> map = new IdentityHashMap<RubySymbol, Type>(this.symbolTypeCache);
        map.put(name2, type2);
        this.symbolTypeCache = map;
        name2.setFFIHandle(type2);
        return type2;
    }

    private Type lookupType(Ruby runtime, IRubyObject name2) {
        IRubyObject type2 = this.ffi.typedefs.fastARef(name2);
        if (type2 instanceof Type) {
            return (Type)type2;
        }
        type2 = this.ffi.ffiModule.callMethod(runtime.getCurrentContext(), "find_type", name2);
        if (type2 instanceof Type) {
            return (Type)type2;
        }
        throw runtime.newTypeError("cannot resolve type " + name2);
    }
}

