/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubySymbol;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.IEqlNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SymbolNode
extends Node
implements ILiteralNode,
INameNode,
IEqlNode {
    private String name;
    private RubySymbol symbol;

    public SymbolNode(ISourcePosition position, String name2) {
        super(position);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SYMBOLNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitSymbolNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public RubySymbol getSymbol(Ruby runtime) {
        RubySymbol sym = this.symbol;
        if (sym != null) {
            return sym;
        }
        this.symbol = runtime.fastNewSymbol(this.name);
        return this.symbol;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        return this.getSymbol(runtime);
    }

    @Override
    public boolean eql(IRubyObject otherValue, ThreadContext context, Ruby runtime, IRubyObject self2, Block aBlock) {
        return otherValue instanceof RubySymbol && ((RubySymbol)otherValue).asJavaString() == this.name;
    }
}

