/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.ast.ListNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public class HashNode
extends Node {
    private final ListNode listNode;

    public HashNode(ISourcePosition position, ListNode listNode) {
        super(position);
        this.listNode = listNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.HASHNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitHashNode(this);
    }

    public ListNode getListNode() {
        return this.listNode;
    }

    @Override
    public List<Node> childNodes() {
        return HashNode.createList((Node)this.listNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        RubyHash hash2;
        ListNode list2 = this.listNode;
        if (list2 != null) {
            int size2 = list2.size();
            hash2 = size2 <= 10 && !runtime.is2_0() ? RubyHash.newSmallHash(runtime) : RubyHash.newHash(runtime);
            int i2 = 0;
            while (i2 < size2) {
                Node valueNode;
                Node keyNode = list2.get(i2++);
                if ((valueNode = list2.get(i2++)) instanceof NilImplicitNode) {
                    IRubyObject kwargsVar = keyNode.interpret(runtime, context, self2, aBlock);
                    IRubyObject kwargsHash = TypeConverter.convertToType19(kwargsVar, runtime.getHash(), "to_hash");
                    hash2.merge_bang19(context, kwargsHash, aBlock);
                    continue;
                }
                IRubyObject key2 = keyNode.interpret(runtime, context, self2, aBlock);
                IRubyObject value2 = valueNode.interpret(runtime, context, self2, aBlock);
                if (size2 <= 10) {
                    this.asetSmall(runtime, hash2, key2, value2);
                    continue;
                }
                this.aset(runtime, hash2, key2, value2);
            }
        } else {
            hash2 = RubyHash.newSmallHash(runtime);
        }
        return hash2;
    }

    protected void aset(Ruby runtime, RubyHash hash2, IRubyObject key2, IRubyObject value2) {
        hash2.fastASetCheckString(runtime, key2, value2);
    }

    protected void asetSmall(Ruby runtime, RubyHash hash2, IRubyObject key2, IRubyObject value2) {
        hash2.fastASetSmallCheckString(runtime, key2, value2);
    }
}

