/*
 * Decompiled with CFR 0.152.
 */
package sbt.complete;

import java.io.File;
import java.net.URI;
import sbt.complete.DefaultParsers$;
import sbt.complete.FileExamples;
import sbt.complete.FileExamples$;
import sbt.complete.Parser;
import sbt.complete.Parser$;
import sbt.complete.Parsers;
import sbt.complete.Parsers$;
import sbt.complete.RichParser;
import sbt.complete.UpperBound$;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public abstract class Parsers$class {
    public static Parser EOF(Parsers $this) {
        return Parser$.MODULE$.not($this.any());
    }

    public static Parser any(Parsers $this) {
        return Parser$.MODULE$.charClass((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$1) {
                return true;
            }
        }, "any character");
    }

    public static Set DigitSet(Parsers $this) {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}));
    }

    public static Parser Digit(Parsers $this) {
        RichParser<Object> qual$1 = Parser$.MODULE$.richParser(Parser$.MODULE$.charClass((Function1<Object, Object>)new Parsers$.anonfun.1($this), "digit"));
        Set<String> x$16 = $this.DigitSet();
        boolean x$17 = qual$1.examples$default$2();
        return qual$1.examples(x$16, x$17);
    }

    public static Set HexDigitSet(Parsers $this) {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'}));
    }

    public static Parser HexDigit(Parsers $this) {
        RichParser<Object> qual$2 = Parser$.MODULE$.richParser(Parser$.MODULE$.charClass((Function1<Object, Object>)new Parsers$.anonfun.2($this), "hex digit"));
        Set x$18 = (Set)$this.HexDigitSet().map((Function1)new Parsers$.anonfun.3($this), Set$.MODULE$.canBuildFrom());
        boolean x$19 = qual$2.examples$default$2();
        return qual$2.examples((Set<String>)x$18, x$19);
    }

    public static Parser Letter(Parsers $this) {
        return Parser$.MODULE$.charClass((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$4) {
                return RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(x$4));
            }
        }, "letter");
    }

    public static Parser IDStart(Parsers $this) {
        return $this.Letter();
    }

    public static Parser IDChar(Parsers $this) {
        return Parser$.MODULE$.charClass((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Parsers $outer;

            public final boolean apply(char c) {
                return this.$outer.isIDChar(c);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "ID character");
    }

    public static Parser ID(Parsers $this) {
        return $this.identifier($this.IDStart(), $this.IDChar());
    }

    public static Parser OpChar(Parsers $this) {
        return Parser$.MODULE$.charClass((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Parsers $outer;

            public final boolean apply(char c) {
                return this.$outer.isOpChar(c);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "symbol");
    }

    public static Parser Op(Parsers $this) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser($this.OpChar()).$plus()).string((Predef$.less.colon.less<Seq<Object>, Seq<Object>>)Predef$.MODULE$.conforms());
    }

    public static Parser OpOrID(Parsers $this) {
        return Parser$.MODULE$.richParser($this.ID()).$bar($this.Op());
    }

    public static Parser ScalaIDChar(Parsers $this) {
        return Parser$.MODULE$.charClass((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Parsers $outer;

            public final boolean apply(char c) {
                return this.$outer.isScalaIDChar(c);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "Scala identifier character");
    }

    public static Parser ScalaID(Parsers $this) {
        return $this.identifier($this.IDStart(), $this.ScalaIDChar());
    }

    public static Parser identifier(Parsers $this, Parser start, Parser rep) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(start).$tilde(Parser$.MODULE$.richParser(rep).$times())).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Object, Seq<Object>> x0$2) {
                Tuple2<Object, Seq<Object>> tuple2 = x0$2;
                Some<Tuple2<Object, Seq<Object>>> some2 = Parser$.MODULE$.$tilde().unapply(tuple2);
                if (some2.isEmpty()) {
                    throw new MatchError(tuple2);
                }
                char x2 = ((Tuple2)some2.get())._1$mcC$sp();
                Seq xs = (Seq)((Tuple2)some2.get())._2();
                char c = x2;
                String string2 = ((TraversableOnce)xs.$plus$colon((Object)BoxesRunTime.boxToCharacter((char)c), Seq$.MODULE$.canBuildFrom())).mkString();
                return string2;
            }
        });
    }

    public static Parser opOrIDSpaced(Parsers $this, String s) {
        return DefaultParsers$.MODULE$.matches($this.ID(), s) ? Parser$.MODULE$.richParser($this.OpChar()).$bar($this.SpaceClass()) : (DefaultParsers$.MODULE$.matches($this.Op(), s) ? Parser$.MODULE$.richParser($this.IDChar()).$bar($this.SpaceClass()) : $this.any());
    }

    public static boolean isOpChar(Parsers $this, char c) {
        return !$this.isDelimiter(c) && $this.isOpType(Character.getType(c));
    }

    public static boolean isOpType(Parsers $this, int cat) {
        boolean bl;
        int n = cat;
        switch (n) {
            default: {
                bl = false;
                break;
            }
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isIDChar(Parsers $this, char c) {
        return $this.isScalaIDChar(c) || c == '-';
    }

    public static boolean isScalaIDChar(Parsers $this, char c) {
        return RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '_';
    }

    public static boolean isDelimiter(Parsers $this, char c) {
        boolean bl;
        char c2 = c;
        switch (c2) {
            default: {
                bl = false;
                break;
            }
            case '\"': 
            case '\'': 
            case ',': 
            case '.': 
            case '`': {
                bl = true;
            }
        }
        return bl;
    }

    public static Parser NotSpaceClass(Parsers $this) {
        return Parser$.MODULE$.charClass((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$6) {
                return !RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(x$6));
            }
        }, "non-whitespace character");
    }

    public static Parser SpaceClass(Parsers $this) {
        return Parser$.MODULE$.charClass((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$7) {
                return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(x$7));
            }
        }, "whitespace character");
    }

    public static Parser NotSpace(Parsers $this) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser($this.NotSpaceClass()).$plus()).string((Predef$.less.colon.less<Seq<Object>, Seq<Object>>)Predef$.MODULE$.conforms());
    }

    public static Parser OptNotSpace(Parsers $this) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser($this.NotSpaceClass()).$times()).string((Predef$.less.colon.less<Seq<Object>, Seq<Object>>)Predef$.MODULE$.conforms());
    }

    public static Parser Space(Parsers $this) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser($this.SpaceClass()).$plus()).examples((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" "}));
    }

    public static Parser OptSpace(Parsers $this) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser($this.SpaceClass()).$times()).examples((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" "}));
    }

    public static Parser URIClass(Parsers $this) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser($this.URIChar()).$plus()).string((Predef$.less.colon.less<Seq<Object>, Seq<Object>>)Predef$.MODULE$.conforms())).$bang$bang$bang("Invalid URI");
    }

    public static String VerbatimDQuotes(Parsers $this) {
        return "\"\"\"";
    }

    public static char DQuoteChar(Parsers $this) {
        return '\"';
    }

    public static char BackslashChar(Parsers $this) {
        return '\\';
    }

    public static Parser DQuoteClass(Parsers $this) {
        return Parser$.MODULE$.charClass((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Parsers $outer;

            public final boolean apply(char x$8) {
                return x$8 == this.$outer.DQuoteChar();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "double-quote character");
    }

    public static Parser NotDQuoteSpaceClass(Parsers $this) {
        return Parser$.MODULE$.charClass((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Parsers $outer;

            public final boolean apply(char c) {
                return c != this.$outer.DQuoteChar() && !RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "non-double-quote-space character");
    }

    public static Parser NotDQuoteBackslashClass(Parsers $this) {
        return Parser$.MODULE$.charClass((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Parsers $outer;

            public final boolean apply(char c) {
                return c != this.$outer.DQuoteChar() && c != this.$outer.BackslashChar();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "non-double-quote-backslash character");
    }

    public static Parser URIChar(Parsers $this) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.charClass((Function1<Object, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Parsers $outer;

            public final boolean apply(char c) {
                return this.$outer.alphanum(c);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Parser$.MODULE$.charClass$default$2())).$bar(Parser$.MODULE$.chars("_-!.~'()*,;:$&+=?/[]@%#"));
    }

    public static boolean alphanum(Parsers $this, char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    public static Parser fileParser(Parsers $this, File base) {
        return Parser$.MODULE$.richParser($this.OptSpace()).$tilde$greater(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser($this.StringBasic()).examples(new FileExamples(base, FileExamples$.MODULE$.$lessinit$greater$default$2()))).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$9) {
                return new File(x$9);
            }
        }));
    }

    public static Parser Port(Parsers $this) {
        return Parser$.MODULE$.token($this.IntBasic(), "<port>");
    }

    public static Parser IntBasic(Parsers $this) {
        return $this.mapOrFail(Parser$.MODULE$.richParser(Parser$.MODULE$.literalRichCharParser('-').$qmark()).$tilde(Parser$.MODULE$.richParser($this.Digit()).$plus()), Function$.MODULE$.tupled((Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Parsers $outer;

            public final int apply(Option<Object> neg, Seq<Object> digits) {
                return Parsers$class.sbt$complete$Parsers$$toInt(this.$outer, neg, digits);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    public static Parser NatBasic(Parsers $this) {
        return $this.mapOrFail(Parser$.MODULE$.richParser($this.Digit()).$plus(), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<Object> x$10) {
                return new StringOps(Predef$.MODULE$.augmentString(x$10.mkString())).toInt();
            }
        });
    }

    public static int sbt$complete$Parsers$$toInt(Parsers $this, Option neg, Seq digits) {
        return new StringOps(Predef$.MODULE$.augmentString(((TraversableOnce)Option$.MODULE$.option2Iterable(neg).toSeq().$plus$plus((GenTraversableOnce)digits, Seq$.MODULE$.canBuildFrom())).mkString())).toInt();
    }

    public static Parser Bool(Parsers $this) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.literalRichStringParser("true").$up$up$up(BoxesRunTime.boxToBoolean((boolean)true))).$bar(Parser$.MODULE$.literalRichStringParser("false").$up$up$up(BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public static Parser StringBasic(Parsers $this) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser($this.StringVerbatim()).$bar($this.StringEscapable())).$bar($this.NotQuoted());
    }

    public static Parser StringVerbatim(Parsers $this) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.literalRichStringParser($this.VerbatimDQuotes()).$tilde$greater(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser($this.any()).$plus()).string((Predef$.less.colon.less<Seq<Object>, Seq<Object>>)Predef$.MODULE$.conforms())).filter((Function1<String, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Parsers $outer;

            public final boolean apply(String x$11) {
                return !x$11.contains(this.$outer.VerbatimDQuotes());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Function1<String, String>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$12) {
                return "Invalid verbatim string";
            }
        }))).$less$tilde(Parser$.MODULE$.literal($this.VerbatimDQuotes()));
    }

    public static Parser StringEscapable(Parsers $this) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.literalRichCharParser($this.DQuoteChar()).$tilde$greater(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser($this.NotDQuoteBackslashClass()).$bar($this.EscapeSequence())).$plus()).string((Predef$.less.colon.less<Seq<Object>, Seq<Object>>)Predef$.MODULE$.conforms()))).$less$tilde(Parser$.MODULE$.literal($this.DQuoteChar()))).$bar(Parser$.MODULE$.richParser(Parser$.MODULE$.literalRichCharParser($this.DQuoteChar()).$tilde(Parser$.MODULE$.literal($this.DQuoteChar()))).$up$up$up(""));
    }

    public static Parser EscapeSequence(Parsers $this) {
        return Parser$.MODULE$.literalRichCharParser($this.BackslashChar()).$tilde$greater(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.literalRichCharParser('b').$up$up$up(BoxesRunTime.boxToCharacter((char)'\b'))).$bar(Parser$.MODULE$.literalRichCharParser('t').$up$up$up(BoxesRunTime.boxToCharacter((char)'\t')))).$bar(Parser$.MODULE$.literalRichCharParser('n').$up$up$up(BoxesRunTime.boxToCharacter((char)'\n')))).$bar(Parser$.MODULE$.literalRichCharParser('f').$up$up$up(BoxesRunTime.boxToCharacter((char)'\f')))).$bar(Parser$.MODULE$.literalRichCharParser('r').$up$up$up(BoxesRunTime.boxToCharacter((char)'\r')))).$bar(Parser$.MODULE$.literalRichCharParser('\"').$up$up$up(BoxesRunTime.boxToCharacter((char)'\"')))).$bar(Parser$.MODULE$.literalRichCharParser('\'').$up$up$up(BoxesRunTime.boxToCharacter((char)'\'')))).$bar(Parser$.MODULE$.literalRichCharParser('\\').$up$up$up(BoxesRunTime.boxToCharacter((char)'\\')))).$bar($this.UnicodeEscape()));
    }

    public static Parser UnicodeEscape(Parsers $this) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.literalRichStringParser("u").$tilde$greater(Parser$.MODULE$.repeat($this.HexDigit(), 4, UpperBound$.MODULE$.intToFinite(4)))).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final char apply(Seq<Object> seq2) {
                return (char)Integer.parseInt(seq2.mkString(), 16);
            }
        });
    }

    public static Parser NotQuoted(Parsers $this) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser($this.NotDQuoteSpaceClass()).$tilde($this.OptNotSpace())).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Object, String> x0$1) {
                Tuple2<Object, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    char c = tuple2._1$mcC$sp();
                    String s = (String)tuple2._2();
                    String string2 = new StringBuilder().append((Object)((Object)BoxesRunTime.boxToCharacter((char)c)).toString()).append((Object)s).toString();
                    return string2;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public static Parser repsep(Parsers $this, Parser rep, Parser sep) {
        return Parser$.MODULE$.richParser($this.rep1sep(rep, sep)).$qmark$qmark(Nil$.MODULE$);
    }

    public static Parser rep1sep(Parsers $this, Parser rep, Parser sep) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(rep).$tilde(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(sep).$tilde$greater(rep)).$times())).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<T> apply(Tuple2<T, Seq<T>> x0$3) {
                Tuple2<T, Seq<T>> tuple2 = x0$3;
                Some<Tuple2<T, Seq<T>>> some2 = Parser$.MODULE$.$tilde().unapply(tuple2);
                if (some2.isEmpty()) {
                    throw new MatchError(tuple2);
                }
                Object x2 = ((Tuple2)some2.get())._1();
                Seq xs = (Seq)((Tuple2)some2.get())._2();
                Object object = x2;
                Seq seq2 = (Seq)xs.$plus$colon(object, Seq$.MODULE$.canBuildFrom());
                return seq2;
            }
        });
    }

    public static Parser some(Parsers $this, Parser p) {
        return Parser$.MODULE$.richParser(p).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Some<T> apply(T v) {
                return new Some(v);
            }
        });
    }

    public static Parser mapOrFail(Parsers $this, Parser p, Function1 f) {
        return Parser$.MODULE$.richParser(p).flatMap(new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$1;

            public final Parser<T> apply(S s) {
                Parser<Object> parser;
                try {
                    parser = Parser$.MODULE$.success(this.f$1.apply(s));
                }
                catch (Exception exception) {
                    parser = Parser$.MODULE$.failure((Function0<String>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$1;

                        public final String apply() {
                            return this.e$1.toString();
                        }
                        {
                            this.e$1 = e$1;
                        }
                    }, Parser$.MODULE$.failure$default$2());
                }
                return parser;
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    public static Parser spaceDelimited(Parsers $this, String display) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parser$.MODULE$.token($this.Space())).$tilde$greater(Parser$.MODULE$.token($this.StringBasic(), display))).$times()).$less$tilde(Parser$.MODULE$.richParser($this.SpaceClass()).$times());
    }

    public static Parser flag(Parsers $this, Parser p) {
        return Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(p).$up$up$up(BoxesRunTime.boxToBoolean((boolean)true))).$qmark$qmark(BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static Parser repeatDep(Parsers $this, Function1 p, Parser sep) {
        return Parser$.MODULE$.richParser((Parser)p.apply((Object)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$))).flatMap(new Serializable($this, p, sep){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Parsers $outer;
            private final Function1 p$1;
            private final Parser sep$1;

            public final Parser<Seq<A>> apply(A first) {
                return Parsers$class.loop$1(this.$outer, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{first})), this.p$1, this.sep$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.p$1 = p$1;
                this.sep$1 = sep$1;
            }
        });
    }

    public static Parser trimmed(Parsers $this, Parser p) {
        return Parser$.MODULE$.richParser(p).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$14) {
                return x$14.trim();
            }
        });
    }

    public static Parser basicUri(Parsers $this) {
        return $this.mapOrFail($this.URIClass(), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final URI apply(String uri) {
                return new URI(uri);
            }
        });
    }

    public static Parser Uri(Parsers $this, Set ex) {
        RichParser<URI> qual$3 = Parser$.MODULE$.richParser($this.basicUri());
        Set x$20 = (Set)ex.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(URI x$15) {
                return x$15.toString();
            }
        }, Set$.MODULE$.canBuildFrom());
        boolean x$21 = qual$3.examples$default$2();
        return qual$3.examples((Set<String>)x$20, x$21);
    }

    public static final Parser loop$1(Parsers $this, Seq acc, Function1 p$1, Parser sep$1) {
        Parser next = Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(sep$1).$tilde$greater((Parser)p$1.apply((Object)acc))).flatMap(new Serializable($this, acc, p$1, sep$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Parsers $outer;
            private final Seq acc$1;
            private final Function1 p$1;
            private final Parser sep$1;

            public final Parser<Seq<A>> apply(A result2) {
                return Parsers$class.loop$1(this.$outer, (Seq)this.acc$1.$colon$plus(result2, Seq$.MODULE$.canBuildFrom()), this.p$1, this.sep$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.acc$1 = acc$1;
                this.p$1 = p$1;
                this.sep$1 = sep$1;
            }
        });
        return Parser$.MODULE$.richParser(next).$qmark$qmark(acc);
    }

    public static void $init$(Parsers $this) {
    }
}

