/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar.util;

import java.io.IOException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.pantsbuild.jarjar.util.EntryStruct;
import org.pantsbuild.jarjar.util.GetNameClassWriter;
import org.pantsbuild.jarjar.util.JarProcessor;

public abstract class JarTransformer
implements JarProcessor {
    @Override
    public boolean process(EntryStruct struct) throws IOException {
        if (struct.name.endsWith(".class") && !struct.skipTransform) {
            ClassReader reader;
            try {
                reader = new ClassReader(struct.data);
            }
            catch (Exception e) {
                System.err.println("Unable to read bytecode from " + struct.name);
                e.printStackTrace();
                return true;
            }
            GetNameClassWriter w = new GetNameClassWriter(1);
            reader.accept(this.transform(w), 8);
            struct.data = w.toByteArray();
            struct.name = JarTransformer.pathFromName(w.getClassName());
        }
        return true;
    }

    protected abstract ClassVisitor transform(ClassVisitor var1);

    private static String pathFromName(String className) {
        return className.replace('.', '/') + ".class";
    }
}

