/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.CommandLine;
import classycle.dependency.DefaultResultRenderer;
import classycle.dependency.ResultRenderer;
import classycle.util.Text;
import java.io.File;
import java.io.IOException;

public class DependencyCheckerCommandLine
extends CommandLine {
    private static final String DEPENDENCIES = "-dependencies=";
    private static final String RENDERER = "-renderer=";
    private String _dependencyDefinition;
    private ResultRenderer _renderer;

    public DependencyCheckerCommandLine(String[] args) {
        super(args);
    }

    protected void handleOption(String argument) {
        if (argument.startsWith(DEPENDENCIES)) {
            this.handleDependenciesOption(argument.substring(DEPENDENCIES.length()));
        } else if (argument.startsWith(RENDERER)) {
            this.handleRenderer(argument.substring(RENDERER.length()));
        } else {
            super.handleOption(argument);
        }
    }

    public String getUsage() {
        return "-dependencies=<description>|@<description file> [-renderer=<fully qualified class name of a ResultRenderer>] " + super.getUsage();
    }

    public String getDependencyDefinition() {
        return this._dependencyDefinition;
    }

    public ResultRenderer getRenderer() {
        return this._renderer == null ? new DefaultResultRenderer() : this._renderer;
    }

    private void handleDependenciesOption(String option) {
        if (option.startsWith("@")) {
            try {
                option = Text.readTextFile(new File(option.substring(1)));
            }
            catch (IOException e) {
                System.err.println("Error in reading dependencies description file: " + e);
                option = "";
            }
        }
        this._dependencyDefinition = option;
        if (this._dependencyDefinition.length() == 0) {
            this._valid = false;
        }
    }

    private void handleRenderer(String className) {
        try {
            this._renderer = (ResultRenderer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            System.err.println("Error in creating ResultRenderer " + className + ": " + e);
            this._valid = false;
        }
    }

    public boolean isValid() {
        return super.isValid() && this._dependencyDefinition != null;
    }
}

