/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.whois.ip;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.inject.assistedinject.Assisted;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog.plugins.threatintel.whois.ip.$AutoValue_WhoisDataAdapter_Config;
import org.graylog.plugins.threatintel.whois.ip.InternetRegistry;
import org.graylog.plugins.threatintel.whois.ip.WhoisIpLookup;
import org.graylog.plugins.threatintel.whois.ip.WhoisIpLookupResult;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.joda.time.Duration;

public class WhoisDataAdapter
extends LookupDataAdapter {
    public static final String NAME = "whois";
    public static final String ORGANIZATION_FIELD = "organization";
    public static final String COUNTRY_CODE_FIELD = "country_code";
    private final WhoisIpLookup whoisIpLookup;

    @Inject
    public WhoisDataAdapter(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupDataAdapterConfiguration config, MetricRegistry metricRegistry) {
        super(id, name, config, metricRegistry);
        this.whoisIpLookup = new WhoisIpLookup((Config)config, metricRegistry);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public Duration refreshInterval() {
        return Duration.ZERO;
    }

    protected void doRefresh(LookupCachePurge cachePurge) throws Exception {
    }

    protected LookupResult doGet(Object key) {
        try {
            WhoisIpLookupResult result = this.whoisIpLookup.run(key.toString());
            if (!WhoisIpLookupResult.empty().equals((Object)result)) {
                ImmutableMap fields = ImmutableMap.of((Object)ORGANIZATION_FIELD, (Object)result.getOrganization(), (Object)COUNTRY_CODE_FIELD, (Object)result.getCountryCode());
                return LookupResult.multi((CharSequence)(result.getOrganization() + "/" + result.getCountryCode()), (Map)fields);
            }
            return LookupResult.empty();
        }
        catch (Exception e) {
            return LookupResult.single((CharSequence)("Lookup Error: " + e.getMessage()));
        }
    }

    public void set(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=Builder.class)
    @JsonTypeName(value="whois")
    @AutoValue
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="registry")
        public abstract InternetRegistry registry();

        @JsonProperty(value="connect_timeout")
        public abstract int connectTimeout();

        @JsonProperty(value="read_timeout")
        public abstract int readTimeout();

        public static Builder builder() {
            return new $AutoValue_WhoisDataAdapter_Config.Builder();
        }

        public Optional<Multimap<String, String>> validate() {
            return Optional.empty();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonCreator
            public static Builder create() {
                return Config.builder().connectTimeout(1000).readTimeout(1000);
            }

            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="registry")
            public abstract Builder registry(InternetRegistry var1);

            @JsonProperty(value="connect_timeout")
            public abstract Builder connectTimeout(int var1);

            @JsonProperty(value="read_timeout")
            public abstract Builder readTimeout(int var1);

            abstract Config autoBuild();

            public Config build() {
                this.registry(InternetRegistry.ARIN);
                return this.autoBuild();
            }
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(WhoisDataAdapter.NAME, Config.class);
        }

        public Config defaultConfiguration() {
            return Config.builder().type(WhoisDataAdapter.NAME).registry(InternetRegistry.ARIN).connectTimeout(1000).readTimeout(1000).build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory<WhoisDataAdapter> {
        public WhoisDataAdapter create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupDataAdapterConfiguration var3);

        public Descriptor getDescriptor();
    }
}

