/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.threatintel.ThreatIntelPluginConfiguration;
import org.graylog.plugins.threatintel.adapters.otx.OTXDataAdapter;
import org.graylog.plugins.threatintel.migrations.AutoValue_V20170821100300_MigrateOTXAPIToken_MigrationCompleted;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.lookup.db.DBDataAdapterService;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.events.DataAdaptersUpdated;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20170821100300_MigrateOTXAPIToken
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20170821100300_MigrateOTXAPIToken.class);
    private static final ImmutableSet<String> OTX_DATA_ADAPTER_NAMES = ImmutableSet.of((Object)"otx-api-ip", (Object)"otx-api-domain");
    private final ClusterConfigService clusterConfigService;
    private final DBDataAdapterService dbDataAdapterService;
    private final ClusterEventBus clusterBus;

    @Inject
    public V20170821100300_MigrateOTXAPIToken(ClusterConfigService clusterConfigService, DBDataAdapterService dbDataAdapterService, ClusterEventBus clusterBus) {
        this.clusterConfigService = clusterConfigService;
        this.dbDataAdapterService = dbDataAdapterService;
        this.clusterBus = clusterBus;
    }

    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2017-08-21T10:03:00Z");
    }

    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        ThreatIntelPluginConfiguration pluginConfig = (ThreatIntelPluginConfiguration)this.clusterConfigService.get(ThreatIntelPluginConfiguration.class);
        if (pluginConfig == null || Strings.isNullOrEmpty((String)pluginConfig.otxApiKey())) {
            LOG.debug("No existing OTX API key found, not running migration.");
            this.clusterConfigService.write((Object)MigrationCompleted.notConvertedKey());
            return;
        }
        String otxApiKey = pluginConfig.otxApiKey();
        Set<String> updatedAdapterIds = OTX_DATA_ADAPTER_NAMES.stream().map(name -> this.updateAdapter((String)name, otxApiKey)).collect(Collectors.toSet());
        this.clusterConfigService.write((Object)MigrationCompleted.convertedKey(updatedAdapterIds));
    }

    private String updateAdapter(String name, String otxApiKey) {
        DataAdapterDto dataAdapterDto = (DataAdapterDto)this.dbDataAdapterService.get(name).orElseThrow(() -> new IllegalStateException("OTX data adapter <" + name + "> not present when trying to add API token."));
        LookupDataAdapterConfiguration adapterConfig = dataAdapterDto.config();
        if (adapterConfig == null || !(adapterConfig instanceof OTXDataAdapter.Config)) {
            throw new IllegalStateException("OTX Data Adapter <" + name + "> does not contain config or config has wrong type.");
        }
        OTXDataAdapter.Config config = (OTXDataAdapter.Config)adapterConfig;
        DataAdapterDto newDto = DataAdapterDto.builder().id(dataAdapterDto.id()).config((LookupDataAdapterConfiguration)config.toBuilder().apiKey(otxApiKey).build()).title(dataAdapterDto.title()).description(dataAdapterDto.description()).name(dataAdapterDto.name()).contentPack(dataAdapterDto.contentPack()).build();
        DataAdapterDto saved = this.dbDataAdapterService.save(newDto);
        this.clusterBus.post((Object)DataAdaptersUpdated.create((String)saved.id()));
        return saved.id();
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="converted_otx_api_key")
        public abstract boolean convertedOTXAPIKey();

        @JsonProperty(value="data_adapter_ids")
        public abstract Set<String> dataAdapterIds();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="data_adapter_ids") Set<String> dataAdapterIds, @JsonProperty(value="converted_otx_api_key") boolean convertedOTXAPIKey) {
            return new AutoValue_V20170821100300_MigrateOTXAPIToken_MigrationCompleted(convertedOTXAPIKey, dataAdapterIds);
        }

        public static MigrationCompleted convertedKey(@JsonProperty(value="data_adapter_ids") Set<String> dataAdapterIds) {
            return MigrationCompleted.create(dataAdapterIds, true);
        }

        public static MigrationCompleted notConvertedKey() {
            return MigrationCompleted.create(Collections.emptySet(), false);
        }
    }
}

