/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.functions.tor;

import com.google.common.base.Strings;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.threatintel.functions.GenericLookupResult;
import org.graylog.plugins.threatintel.functions.misc.LookupTableFunction;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.plugin.lookup.LookupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorExitNodeLookupFunction
extends LookupTableFunction<GenericLookupResult> {
    private static final Logger LOG = LoggerFactory.getLogger(TorExitNodeLookupFunction.class);
    public static final String NAME = "tor_lookup";
    private static final String VALUE = "ip_address";
    private static final String LOOKUP_TABLE_NAME = "tor-exit-node-list";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string((String)"ip_address").description("The IP to look up.").build();
    private final LookupTableService.Function lookupFunction;

    @Inject
    public TorExitNodeLookupFunction(LookupTableService lookupTableService) {
        this.lookupFunction = lookupTableService.newBuilder().lookupTable(LOOKUP_TABLE_NAME).build();
    }

    public GenericLookupResult evaluate(FunctionArgs args, EvaluationContext context) {
        Object value;
        String ip = (String)this.valueParam.required(args, context);
        if (ip == null) {
            LOG.error("NULL parameter passed to Tor exit node lookup.");
            return null;
        }
        LOG.debug("Running Tor exit node lookup for IP [{}].", (Object)ip);
        LookupResult lookupResult = this.lookupFunction.lookup((Object)ip.trim());
        if (lookupResult != null && !lookupResult.isEmpty() && (value = lookupResult.singleValue()) instanceof String) {
            return !Strings.isNullOrEmpty((String)((String)value)) ? GenericLookupResult.TRUE : GenericLookupResult.FALSE;
        }
        return GenericLookupResult.FALSE;
    }

    public FunctionDescriptor<GenericLookupResult> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Match an IP address against known Tor exit nodes to identify connections from the Tor network.").params(new ParameterDescriptor[]{this.valueParam}).returnType(GenericLookupResult.class).build();
    }
}

