/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateTransitGatewayConnectRequest;
import com.amazonaws.services.ec2.model.CreateTransitGatewayConnectRequestOptions;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateTransitGatewayConnectRequestMarshaller
implements Marshaller<Request<CreateTransitGatewayConnectRequest>, CreateTransitGatewayConnectRequest> {
    @Override
    public Request<CreateTransitGatewayConnectRequest> marshall(CreateTransitGatewayConnectRequest createTransitGatewayConnectRequest) {
        SdkInternalList createTransitGatewayConnectRequestTagSpecificationsList;
        CreateTransitGatewayConnectRequestOptions options;
        if (createTransitGatewayConnectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateTransitGatewayConnectRequest> request = new DefaultRequest<CreateTransitGatewayConnectRequest>(createTransitGatewayConnectRequest, "AmazonEC2");
        request.addParameter("Action", "CreateTransitGatewayConnect");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTransitGatewayConnectRequest.getTransportTransitGatewayAttachmentId() != null) {
            request.addParameter("TransportTransitGatewayAttachmentId", StringUtils.fromString(createTransitGatewayConnectRequest.getTransportTransitGatewayAttachmentId()));
        }
        if ((options = createTransitGatewayConnectRequest.getOptions()) != null && options.getProtocol() != null) {
            request.addParameter("Options.Protocol", StringUtils.fromString(options.getProtocol()));
        }
        if (!(createTransitGatewayConnectRequestTagSpecificationsList = (SdkInternalList)createTransitGatewayConnectRequest.getTagSpecifications()).isEmpty() || !createTransitGatewayConnectRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createTransitGatewayConnectRequestTagSpecificationsListValue : createTransitGatewayConnectRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createTransitGatewayConnectRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createTransitGatewayConnectRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createTransitGatewayConnectRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

