/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.FpgaImageAttributeName;
import com.amazonaws.services.ec2.model.LoadPermissionModifications;
import com.amazonaws.services.ec2.model.OperationType;
import com.amazonaws.services.ec2.model.transform.ModifyFpgaImageAttributeRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyFpgaImageAttributeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ModifyFpgaImageAttributeRequest> {
    private String fpgaImageId;
    private String attribute;
    private String operationType;
    private SdkInternalList<String> userIds;
    private SdkInternalList<String> userGroups;
    private SdkInternalList<String> productCodes;
    private LoadPermissionModifications loadPermission;
    private String description;
    private String name;

    public void setFpgaImageId(String fpgaImageId) {
        this.fpgaImageId = fpgaImageId;
    }

    public String getFpgaImageId() {
        return this.fpgaImageId;
    }

    public ModifyFpgaImageAttributeRequest withFpgaImageId(String fpgaImageId) {
        this.setFpgaImageId(fpgaImageId);
        return this;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public ModifyFpgaImageAttributeRequest withAttribute(String attribute) {
        this.setAttribute(attribute);
        return this;
    }

    public ModifyFpgaImageAttributeRequest withAttribute(FpgaImageAttributeName attribute) {
        this.attribute = attribute.toString();
        return this;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public ModifyFpgaImageAttributeRequest withOperationType(String operationType) {
        this.setOperationType(operationType);
        return this;
    }

    public ModifyFpgaImageAttributeRequest withOperationType(OperationType operationType) {
        this.operationType = operationType.toString();
        return this;
    }

    public List<String> getUserIds() {
        if (this.userIds == null) {
            this.userIds = new SdkInternalList();
        }
        return this.userIds;
    }

    public void setUserIds(Collection<String> userIds) {
        if (userIds == null) {
            this.userIds = null;
            return;
        }
        this.userIds = new SdkInternalList<String>(userIds);
    }

    public ModifyFpgaImageAttributeRequest withUserIds(String ... userIds) {
        if (this.userIds == null) {
            this.setUserIds(new SdkInternalList<String>(userIds.length));
        }
        for (String ele : userIds) {
            this.userIds.add(ele);
        }
        return this;
    }

    public ModifyFpgaImageAttributeRequest withUserIds(Collection<String> userIds) {
        this.setUserIds(userIds);
        return this;
    }

    public List<String> getUserGroups() {
        if (this.userGroups == null) {
            this.userGroups = new SdkInternalList();
        }
        return this.userGroups;
    }

    public void setUserGroups(Collection<String> userGroups) {
        if (userGroups == null) {
            this.userGroups = null;
            return;
        }
        this.userGroups = new SdkInternalList<String>(userGroups);
    }

    public ModifyFpgaImageAttributeRequest withUserGroups(String ... userGroups) {
        if (this.userGroups == null) {
            this.setUserGroups(new SdkInternalList<String>(userGroups.length));
        }
        for (String ele : userGroups) {
            this.userGroups.add(ele);
        }
        return this;
    }

    public ModifyFpgaImageAttributeRequest withUserGroups(Collection<String> userGroups) {
        this.setUserGroups(userGroups);
        return this;
    }

    public List<String> getProductCodes() {
        if (this.productCodes == null) {
            this.productCodes = new SdkInternalList();
        }
        return this.productCodes;
    }

    public void setProductCodes(Collection<String> productCodes) {
        if (productCodes == null) {
            this.productCodes = null;
            return;
        }
        this.productCodes = new SdkInternalList<String>(productCodes);
    }

    public ModifyFpgaImageAttributeRequest withProductCodes(String ... productCodes) {
        if (this.productCodes == null) {
            this.setProductCodes(new SdkInternalList<String>(productCodes.length));
        }
        for (String ele : productCodes) {
            this.productCodes.add(ele);
        }
        return this;
    }

    public ModifyFpgaImageAttributeRequest withProductCodes(Collection<String> productCodes) {
        this.setProductCodes(productCodes);
        return this;
    }

    public void setLoadPermission(LoadPermissionModifications loadPermission) {
        this.loadPermission = loadPermission;
    }

    public LoadPermissionModifications getLoadPermission() {
        return this.loadPermission;
    }

    public ModifyFpgaImageAttributeRequest withLoadPermission(LoadPermissionModifications loadPermission) {
        this.setLoadPermission(loadPermission);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ModifyFpgaImageAttributeRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ModifyFpgaImageAttributeRequest withName(String name) {
        this.setName(name);
        return this;
    }

    @Override
    public Request<ModifyFpgaImageAttributeRequest> getDryRunRequest() {
        Request<ModifyFpgaImageAttributeRequest> request = new ModifyFpgaImageAttributeRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFpgaImageId() != null) {
            sb.append("FpgaImageId: ").append(this.getFpgaImageId()).append(",");
        }
        if (this.getAttribute() != null) {
            sb.append("Attribute: ").append(this.getAttribute()).append(",");
        }
        if (this.getOperationType() != null) {
            sb.append("OperationType: ").append(this.getOperationType()).append(",");
        }
        if (this.getUserIds() != null) {
            sb.append("UserIds: ").append(this.getUserIds()).append(",");
        }
        if (this.getUserGroups() != null) {
            sb.append("UserGroups: ").append(this.getUserGroups()).append(",");
        }
        if (this.getProductCodes() != null) {
            sb.append("ProductCodes: ").append(this.getProductCodes()).append(",");
        }
        if (this.getLoadPermission() != null) {
            sb.append("LoadPermission: ").append(this.getLoadPermission()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyFpgaImageAttributeRequest)) {
            return false;
        }
        ModifyFpgaImageAttributeRequest other = (ModifyFpgaImageAttributeRequest)obj;
        if (other.getFpgaImageId() == null ^ this.getFpgaImageId() == null) {
            return false;
        }
        if (other.getFpgaImageId() != null && !other.getFpgaImageId().equals(this.getFpgaImageId())) {
            return false;
        }
        if (other.getAttribute() == null ^ this.getAttribute() == null) {
            return false;
        }
        if (other.getAttribute() != null && !other.getAttribute().equals(this.getAttribute())) {
            return false;
        }
        if (other.getOperationType() == null ^ this.getOperationType() == null) {
            return false;
        }
        if (other.getOperationType() != null && !other.getOperationType().equals(this.getOperationType())) {
            return false;
        }
        if (other.getUserIds() == null ^ this.getUserIds() == null) {
            return false;
        }
        if (other.getUserIds() != null && !other.getUserIds().equals(this.getUserIds())) {
            return false;
        }
        if (other.getUserGroups() == null ^ this.getUserGroups() == null) {
            return false;
        }
        if (other.getUserGroups() != null && !other.getUserGroups().equals(this.getUserGroups())) {
            return false;
        }
        if (other.getProductCodes() == null ^ this.getProductCodes() == null) {
            return false;
        }
        if (other.getProductCodes() != null && !other.getProductCodes().equals(this.getProductCodes())) {
            return false;
        }
        if (other.getLoadPermission() == null ^ this.getLoadPermission() == null) {
            return false;
        }
        if (other.getLoadPermission() != null && !other.getLoadPermission().equals(this.getLoadPermission())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        return other.getName() == null || other.getName().equals(this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFpgaImageId() == null ? 0 : this.getFpgaImageId().hashCode());
        hashCode = 31 * hashCode + (this.getAttribute() == null ? 0 : this.getAttribute().hashCode());
        hashCode = 31 * hashCode + (this.getOperationType() == null ? 0 : this.getOperationType().hashCode());
        hashCode = 31 * hashCode + (this.getUserIds() == null ? 0 : this.getUserIds().hashCode());
        hashCode = 31 * hashCode + (this.getUserGroups() == null ? 0 : this.getUserGroups().hashCode());
        hashCode = 31 * hashCode + (this.getProductCodes() == null ? 0 : this.getProductCodes().hashCode());
        hashCode = 31 * hashCode + (this.getLoadPermission() == null ? 0 : this.getLoadPermission().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        return hashCode;
    }

    @Override
    public ModifyFpgaImageAttributeRequest clone() {
        return (ModifyFpgaImageAttributeRequest)super.clone();
    }
}

