/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6.jest;

import com.fasterxml.jackson.databind.JsonNode;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.http.JestHttpClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.http.client.config.RequestConfig;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.FieldTypeException;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.InvalidWriteTargetException;
import org.graylog2.indexer.MasterNotDiscoveredException;
import org.graylog2.indexer.QueryParsingException;

public class JestUtils {
    private static final Pattern invalidWriteTarget = Pattern.compile("no write index is defined for alias \\[(?<target>[\\w_]+)\\]");

    private JestUtils() {
    }

    public static <T extends JestResult> T executeUnsafe(JestClient client, RequestConfig requestConfig, Action<T> request, Supplier<String> errorMessage) {
        T result;
        try {
            result = client instanceof JestHttpClient ? ((JestHttpClient)client).execute(request, requestConfig) : client.execute(request);
        }
        catch (IOException e) {
            throw new ElasticsearchException(errorMessage.get(), (Throwable)e);
        }
        return result;
    }

    public static <T extends JestResult> T execute(JestClient client, RequestConfig requestConfig, Action<T> request, Supplier<String> errorMessage) {
        T result = JestUtils.executeUnsafe(client, requestConfig, request, errorMessage);
        if (((JestResult)result).isSucceeded()) {
            return result;
        }
        throw JestUtils.specificException(errorMessage, ((JestResult)result).getJsonObject().path("error"));
    }

    public static <T extends JestResult> T execute(JestClient client, Action<T> request, Supplier<String> errorMessage) {
        return JestUtils.execute(client, null, request, errorMessage);
    }

    public static <T extends JestResult> T execute(JestClient client, RequestConfig requestConfig, Action<T> request) throws IOException {
        if (client instanceof JestHttpClient) {
            return ((JestHttpClient)client).execute(request, requestConfig);
        }
        return client.execute(request);
    }

    public static ElasticsearchException specificException(Supplier<String> errorMessage, JsonNode errorNode) {
        JsonNode rootCauses = errorNode.path("root_cause");
        ArrayList<String> reasons = new ArrayList<String>(rootCauses.size());
        for (JsonNode rootCause : rootCauses) {
            JsonNode type;
            JsonNode reason = rootCause.path("reason");
            if (reason.isTextual()) {
                reasons.add(reason.asText());
            }
            if (!(type = rootCause.path("type")).isTextual()) continue;
            switch (type.asText()) {
                case "master_not_discovered_exception": {
                    return new MasterNotDiscoveredException();
                }
                case "cluster_block_exception": {
                    if (reason.asText().contains("no master")) {
                        return new MasterNotDiscoveredException();
                    }
                }
                case "query_parsing_exception": {
                    return JestUtils.buildQueryParsingException(errorMessage, rootCause, reasons);
                }
                case "index_not_found_exception": {
                    String indexName = rootCause.path("resource.id").asText();
                    return IndexNotFoundException.create((String)errorMessage.get(), (String)indexName);
                }
                case "illegal_argument_exception": {
                    Matcher matcher;
                    String reasonText = reason.asText();
                    if (reasonText.startsWith("Expected numeric type on field")) {
                        return JestUtils.buildFieldTypeException(errorMessage, reasonText);
                    }
                    if (!reasonText.startsWith("no write index is defined for alias") || !(matcher = invalidWriteTarget.matcher(reasonText)).find()) break;
                    String target = matcher.group("target");
                    return InvalidWriteTargetException.create((String)target);
                }
            }
        }
        if (reasons.isEmpty()) {
            return new ElasticsearchException(errorMessage.get(), Collections.singletonList(errorNode.toString()));
        }
        return new ElasticsearchException(errorMessage.get(), JestUtils.deduplicateErrors(reasons));
    }

    public static List<String> deduplicateErrors(List<String> errors) {
        return errors.stream().distinct().collect(Collectors.toList());
    }

    private static FieldTypeException buildFieldTypeException(Supplier<String> errorMessage, String reason) {
        return new FieldTypeException(errorMessage.get(), reason);
    }

    private static QueryParsingException buildQueryParsingException(Supplier<String> errorMessage, JsonNode rootCause, List<String> reasons) {
        JsonNode lineJson = rootCause.path("line");
        Integer line = lineJson.isInt() ? Integer.valueOf(lineJson.asInt()) : null;
        JsonNode columnJson = rootCause.path("col");
        Integer column = columnJson.isInt() ? Integer.valueOf(columnJson.asInt()) : null;
        String index = rootCause.path("index").asText(null);
        return new QueryParsingException(errorMessage.get(), line, column, index, reasons);
    }

    public static Optional<ElasticsearchException> checkForFailedShards(JestResult result) {
        JsonNode shards = result.getJsonObject().path("_shards");
        double failedShards = shards.path("failed").asDouble();
        if (failedShards > 0.0) {
            List<String> errors = StreamSupport.stream(shards.path("failures").spliterator(), false).map(failure -> failure.path("reason").path("reason").asText()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            List<String> nonNumericFieldErrors = errors.stream().filter(error -> error.startsWith("Expected numeric type on field")).collect(Collectors.toList());
            if (!nonNumericFieldErrors.isEmpty()) {
                return Optional.of(new FieldTypeException("Unable to perform search query: ", JestUtils.deduplicateErrors(nonNumericFieldErrors)));
            }
            return Optional.of(new ElasticsearchException("Unable to perform search query: ", JestUtils.deduplicateErrors(errors)));
        }
        return Optional.empty();
    }
}

