/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight;

import java.text.BreakIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.highlight.Encoder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.BaseFragmentsBuilder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.BreakIteratorBoundaryScanner;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.CustomFieldQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.FragListBuilder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.SimpleBoundaryScanner;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.SimpleFieldFragList;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.SimpleFragListBuilder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.SingleFragListBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.text.Text;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.FetchSubPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.HighlightUtils;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.HighlighterContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.SimpleFragmentsBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.SourceScoreOrderFragmentsBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.SourceSimpleFragmentsBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

public class FastVectorHighlighter
implements Highlighter {
    private static final BoundaryScanner DEFAULT_SIMPLE_BOUNDARY_SCANNER = new SimpleBoundaryScanner();
    private static final BoundaryScanner DEFAULT_SENTENCE_BOUNDARY_SCANNER = new BreakIteratorBoundaryScanner(BreakIterator.getSentenceInstance(Locale.ROOT));
    private static final BoundaryScanner DEFAULT_WORD_BOUNDARY_SCANNER = new BreakIteratorBoundaryScanner(BreakIterator.getWordInstance(Locale.ROOT));
    public static final Setting<Boolean> SETTING_TV_HIGHLIGHT_MULTI_VALUE = Setting.boolSetting("search.highlight.term_vector_multi_value", true, Setting.Property.NodeScope);
    private static final String CACHE_KEY = "highlight-fsv";
    private final Boolean termVectorMultiValue;

    public FastVectorHighlighter(Settings settings) {
        this.termVectorMultiValue = SETTING_TV_HIGHLIGHT_MULTI_VALUE.get(settings);
    }

    @Override
    public HighlightField highlight(HighlighterContext highlighterContext) {
        Encoder encoder;
        SearchContextHighlight.Field field = highlighterContext.field;
        SearchContext context = highlighterContext.context;
        FetchSubPhase.HitContext hitContext = highlighterContext.hitContext;
        FieldMapper mapper = highlighterContext.mapper;
        if (!this.canHighlight(mapper)) {
            throw new IllegalArgumentException("the field [" + highlighterContext.fieldName + "] should be indexed with term vector with position offsets to be used with fast vector highlighter");
        }
        Encoder encoder2 = encoder = field.fieldOptions().encoder().equals("html") ? HighlightUtils.Encoders.HTML : HighlightUtils.Encoders.DEFAULT;
        if (!hitContext.cache().containsKey(CACHE_KEY)) {
            hitContext.cache().put(CACHE_KEY, new HighlighterEntry());
        }
        HighlighterEntry cache = (HighlighterEntry)hitContext.cache().get(CACHE_KEY);
        try {
            MapperHighlightEntry entry = cache.mappers.get(mapper);
            if (entry == null) {
                BaseFragmentsBuilder fragmentsBuilder;
                FragListBuilder fragListBuilder;
                BoundaryScanner boundaryScanner = FastVectorHighlighter.getBoundaryScanner(field);
                boolean forceSource = context.highlight().forceSource(field);
                if (field.fieldOptions().numberOfFragments() == 0) {
                    fragListBuilder = new SingleFragListBuilder();
                    fragmentsBuilder = !forceSource && mapper.fieldType().stored() ? new SimpleFragmentsBuilder(mapper, field.fieldOptions().preTags(), field.fieldOptions().postTags(), boundaryScanner) : new SourceSimpleFragmentsBuilder(mapper, context, field.fieldOptions().preTags(), field.fieldOptions().postTags(), boundaryScanner);
                } else {
                    FragListBuilder fragListBuilder2 = fragListBuilder = field.fieldOptions().fragmentOffset() == -1 ? new SimpleFragListBuilder() : new SimpleFragListBuilder(field.fieldOptions().fragmentOffset());
                    fragmentsBuilder = field.fieldOptions().scoreOrdered().booleanValue() ? (!forceSource && mapper.fieldType().stored() ? new ScoreOrderFragmentsBuilder(field.fieldOptions().preTags(), field.fieldOptions().postTags(), boundaryScanner) : new SourceScoreOrderFragmentsBuilder(mapper, context, field.fieldOptions().preTags(), field.fieldOptions().postTags(), boundaryScanner)) : (!forceSource && mapper.fieldType().stored() ? new SimpleFragmentsBuilder(mapper, field.fieldOptions().preTags(), field.fieldOptions().postTags(), boundaryScanner) : new SourceSimpleFragmentsBuilder(mapper, context, field.fieldOptions().preTags(), field.fieldOptions().postTags(), boundaryScanner));
                }
                fragmentsBuilder.setDiscreteMultiValueHighlighting(this.termVectorMultiValue);
                entry = new MapperHighlightEntry();
                if (field.fieldOptions().requireFieldMatch().booleanValue()) {
                    entry.fieldMatchFieldQuery = new CustomFieldQuery(highlighterContext.query, hitContext.topLevelReader(), true, field.fieldOptions().requireFieldMatch());
                } else {
                    entry.noFieldMatchFieldQuery = new CustomFieldQuery(highlighterContext.query, hitContext.topLevelReader(), true, field.fieldOptions().requireFieldMatch());
                }
                entry.fragListBuilder = fragListBuilder;
                entry.fragmentsBuilder = fragmentsBuilder;
                if (cache.fvh == null) {
                    cache.fvh = new org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.FastVectorHighlighter();
                }
                CustomFieldQuery.highlightFilters.set(field.fieldOptions().highlightFilter());
                cache.mappers.put(mapper, entry);
            }
            FieldQuery fieldQuery = field.fieldOptions().requireFieldMatch() != false ? entry.fieldMatchFieldQuery : entry.noFieldMatchFieldQuery;
            cache.fvh.setPhraseLimit(field.fieldOptions().phraseLimit());
            int numberOfFragments = field.fieldOptions().numberOfFragments() == 0 ? Integer.MAX_VALUE : field.fieldOptions().numberOfFragments();
            int fragmentCharSize = field.fieldOptions().numberOfFragments() == 0 ? Integer.MAX_VALUE : field.fieldOptions().fragmentCharSize();
            String[] fragments = field.fieldOptions().matchedFields() != null && !field.fieldOptions().matchedFields().isEmpty() ? cache.fvh.getBestFragments(fieldQuery, hitContext.reader(), hitContext.docId(), mapper.fieldType().name(), field.fieldOptions().matchedFields(), fragmentCharSize, numberOfFragments, entry.fragListBuilder, entry.fragmentsBuilder, field.fieldOptions().preTags(), field.fieldOptions().postTags(), encoder) : cache.fvh.getBestFragments(fieldQuery, hitContext.reader(), hitContext.docId(), mapper.fieldType().name(), fragmentCharSize, numberOfFragments, entry.fragListBuilder, entry.fragmentsBuilder, field.fieldOptions().preTags(), field.fieldOptions().postTags(), encoder);
            if (fragments != null && fragments.length > 0) {
                return new HighlightField(highlighterContext.fieldName, Text.convertFromStringArray(fragments));
            }
            int noMatchSize = highlighterContext.field.fieldOptions().noMatchSize();
            if (noMatchSize > 0) {
                SimpleFieldFragList fieldFragList = new SimpleFieldFragList(-1);
                ((FieldFragList)fieldFragList).add(0, noMatchSize, Collections.emptyList());
                fragments = entry.fragmentsBuilder.createFragments(hitContext.reader(), hitContext.docId(), mapper.fieldType().name(), fieldFragList, 1, field.fieldOptions().preTags(), field.fieldOptions().postTags(), encoder);
                if (fragments != null && fragments.length > 0) {
                    return new HighlightField(highlighterContext.fieldName, Text.convertFromStringArray(fragments));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
        }
    }

    @Override
    public boolean canHighlight(FieldMapper fieldMapper) {
        return fieldMapper.fieldType().storeTermVectors() && fieldMapper.fieldType().storeTermVectorOffsets() && fieldMapper.fieldType().storeTermVectorPositions();
    }

    private static BoundaryScanner getBoundaryScanner(SearchContextHighlight.Field field) {
        SearchContextHighlight.FieldOptions fieldOptions = field.fieldOptions();
        Locale boundaryScannerLocale = fieldOptions.boundaryScannerLocale() != null ? fieldOptions.boundaryScannerLocale() : Locale.ROOT;
        HighlightBuilder.BoundaryScannerType type = fieldOptions.boundaryScannerType() != null ? fieldOptions.boundaryScannerType() : HighlightBuilder.BoundaryScannerType.CHARS;
        switch (type) {
            case SENTENCE: {
                if (boundaryScannerLocale != null) {
                    return new BreakIteratorBoundaryScanner(BreakIterator.getSentenceInstance(boundaryScannerLocale));
                }
                return DEFAULT_SENTENCE_BOUNDARY_SCANNER;
            }
            case WORD: {
                if (boundaryScannerLocale != null) {
                    return new BreakIteratorBoundaryScanner(BreakIterator.getWordInstance(boundaryScannerLocale));
                }
                return DEFAULT_WORD_BOUNDARY_SCANNER;
            }
            case CHARS: {
                if (fieldOptions.boundaryMaxScan() != 20 || fieldOptions.boundaryChars() != SimpleBoundaryScanner.DEFAULT_BOUNDARY_CHARS) {
                    return new SimpleBoundaryScanner(fieldOptions.boundaryMaxScan(), fieldOptions.boundaryChars());
                }
                return DEFAULT_SIMPLE_BOUNDARY_SCANNER;
            }
        }
        throw new IllegalArgumentException("Invalid boundary scanner type: " + type.toString());
    }

    private class HighlighterEntry {
        public org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.FastVectorHighlighter fvh;
        public Map<FieldMapper, MapperHighlightEntry> mappers = new HashMap<FieldMapper, MapperHighlightEntry>();

        private HighlighterEntry() {
        }
    }

    private class MapperHighlightEntry {
        public FragListBuilder fragListBuilder;
        public FragmentsBuilder fragmentsBuilder;
        public FieldQuery noFieldMatchFieldQuery;
        public FieldQuery fieldMatchFieldQuery;

        private MapperHighlightEntry() {
        }
    }
}

