/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket;

import java.util.Comparator;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.util.Comparators;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregations;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.HasAggregations;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.support.AggregationPath;

public interface MultiBucketsAggregation
extends Aggregation {
    public List<? extends Bucket> getBuckets();

    public static interface Bucket
    extends HasAggregations,
    ToXContent {
        public Object getKey();

        public String getKeyAsString();

        public long getDocCount();

        @Override
        public Aggregations getAggregations();

        public static class SubAggregationComparator<B extends Bucket>
        implements Comparator<B> {
            private final AggregationPath path;
            private final boolean asc;

            public SubAggregationComparator(String expression, boolean asc) {
                this.asc = asc;
                this.path = AggregationPath.parse(expression);
            }

            public boolean asc() {
                return this.asc;
            }

            public AggregationPath path() {
                return this.path;
            }

            @Override
            public int compare(B b1, B b2) {
                double v1 = this.path.resolveValue((HasAggregations)b1);
                double v2 = this.path.resolveValue((HasAggregations)b2);
                return Comparators.compareDiscardNaN(v1, v2, this.asc);
            }
        }
    }
}

