/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.document;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.get.MultiGetRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.get.MultiGetResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestToXContentListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class RestMultiGetAction
extends BaseRestHandler {
    private final boolean allowExplicitIndex;

    public RestMultiGetAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_mget", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mget", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mget", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mget", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mget", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mget", this);
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MultiGetRequest multiGetRequest = new MultiGetRequest();
        multiGetRequest.refresh(request.paramAsBoolean("refresh", multiGetRequest.refresh()));
        multiGetRequest.preference(request.param("preference"));
        multiGetRequest.realtime(request.paramAsBoolean("realtime", multiGetRequest.realtime()));
        if (request.param("fields") != null) {
            throw new IllegalArgumentException("The parameter [fields] is no longer supported, please use [stored_fields] to retrieve stored fields or _source filtering if the field is not stored");
        }
        String[] sFields = null;
        String sField = request.param("stored_fields");
        if (sField != null) {
            sFields = Strings.splitStringByCommaToArray(sField);
        }
        FetchSourceContext defaultFetchSource = FetchSourceContext.parseFromRestRequest(request);
        try (XContentParser parser = request.contentOrSourceParamParser();){
            multiGetRequest.add(request.param("index"), request.param("type"), sFields, defaultFetchSource, request.param("routing"), parser, this.allowExplicitIndex);
        }
        return channel -> client.multiGet(multiGetRequest, new RestToXContentListener<MultiGetResponse>((RestChannel)channel));
    }
}

