/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.document;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.get.GetRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.get.GetResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BytesRestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestStatus;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestResponseListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class RestGetSourceAction
extends BaseRestHandler {
    public RestGetSourceAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_source", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/{type}/{id}/_source", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        GetRequest getRequest = new GetRequest(request.param("index"), request.param("type"), request.param("id"));
        getRequest.operationThreaded(true);
        getRequest.refresh(request.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.routing(request.param("routing"));
        getRequest.parent(request.param("parent"));
        getRequest.preference(request.param("preference"));
        getRequest.realtime(request.paramAsBoolean("realtime", getRequest.realtime()));
        getRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest(request));
        return channel -> {
            if (getRequest.fetchSourceContext() != null && !getRequest.fetchSourceContext().fetchSource()) {
                ActionRequestValidationException validationError = new ActionRequestValidationException();
                validationError.addValidationError("fetching source can not be disabled");
                channel.sendResponse(new BytesRestResponse((RestChannel)channel, validationError));
            } else {
                client.get(getRequest, (ActionListener<GetResponse>)new RestResponseListener<GetResponse>(channel){

                    @Override
                    public RestResponse buildResponse(GetResponse response) throws Exception {
                        XContentBuilder builder = this.channel.newBuilder(request.getXContentType(), false);
                        if (response.isSourceEmpty()) {
                            return new BytesRestResponse(RestStatus.NOT_FOUND, builder);
                        }
                        builder.rawValue(response.getSourceInternal());
                        return new BytesRestResponse(RestStatus.OK, builder);
                    }
                });
            }
        };
    }
}

