/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.validate.query.QueryExplanation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParsingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BytesRestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestStatus;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestActions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestBuilderListener;

public class RestValidateQueryAction
extends BaseRestHandler {
    private static final String INDEX_FIELD = "index";
    private static final String SHARD_FIELD = "shard";
    private static final String VALID_FIELD = "valid";
    private static final String EXPLANATIONS_FIELD = "explanations";
    private static final String ERROR_FIELD = "error";
    private static final String EXPLANATION_FIELD = "explanation";

    public RestValidateQueryAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/_validate/query", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_validate/query", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        ValidateQueryRequest validateQueryRequest = new ValidateQueryRequest(Strings.splitStringByCommaToArray(request.param(INDEX_FIELD)));
        validateQueryRequest.indicesOptions(IndicesOptions.fromRequest(request, validateQueryRequest.indicesOptions()));
        validateQueryRequest.explain(request.paramAsBoolean("explain", false));
        validateQueryRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
        validateQueryRequest.rewrite(request.paramAsBoolean("rewrite", false));
        validateQueryRequest.allShards(request.paramAsBoolean("all_shards", false));
        Exception bodyParsingException = null;
        try {
            request.withContentOrSourceParamParserOrNull(parser -> {
                if (parser != null) {
                    validateQueryRequest.query(RestActions.getQueryContent(parser));
                } else if (request.hasParam("q")) {
                    validateQueryRequest.query(RestActions.urlParamsToQueryBuilder(request));
                }
            });
        }
        catch (Exception e) {
            bodyParsingException = e;
        }
        Exception finalBodyParsingException = bodyParsingException;
        return channel -> {
            if (finalBodyParsingException != null) {
                if (finalBodyParsingException instanceof ParsingException) {
                    this.handleException(validateQueryRequest, ((ParsingException)finalBodyParsingException).getDetailedMessage(), (RestChannel)channel);
                } else {
                    this.handleException(validateQueryRequest, finalBodyParsingException.getMessage(), (RestChannel)channel);
                }
            } else {
                client.admin().indices().validateQuery(validateQueryRequest, (ActionListener<ValidateQueryResponse>)new RestBuilderListener<ValidateQueryResponse>(channel){

                    @Override
                    public RestResponse buildResponse(ValidateQueryResponse response, XContentBuilder builder) throws Exception {
                        builder.startObject();
                        builder.field(RestValidateQueryAction.VALID_FIELD, response.isValid());
                        RestActions.buildBroadcastShardsHeader(builder, request, response);
                        if (response.getQueryExplanation() != null && !response.getQueryExplanation().isEmpty()) {
                            builder.startArray(RestValidateQueryAction.EXPLANATIONS_FIELD);
                            for (QueryExplanation queryExplanation : response.getQueryExplanation()) {
                                builder.startObject();
                                if (queryExplanation.getIndex() != null) {
                                    builder.field(RestValidateQueryAction.INDEX_FIELD, queryExplanation.getIndex());
                                }
                                if (queryExplanation.getShard() >= 0) {
                                    builder.field(RestValidateQueryAction.SHARD_FIELD, queryExplanation.getShard());
                                }
                                builder.field(RestValidateQueryAction.VALID_FIELD, queryExplanation.isValid());
                                if (queryExplanation.getError() != null) {
                                    builder.field(RestValidateQueryAction.ERROR_FIELD, queryExplanation.getError());
                                }
                                if (queryExplanation.getExplanation() != null) {
                                    builder.field(RestValidateQueryAction.EXPLANATION_FIELD, queryExplanation.getExplanation());
                                }
                                builder.endObject();
                            }
                            builder.endArray();
                        }
                        builder.endObject();
                        return new BytesRestResponse(RestStatus.OK, builder);
                    }
                });
            }
        };
    }

    private void handleException(ValidateQueryRequest request, String message, RestChannel channel) throws IOException {
        channel.sendResponse(RestValidateQueryAction.buildErrorResponse(channel.newBuilder(), message, request.explain()));
    }

    private static BytesRestResponse buildErrorResponse(XContentBuilder builder, String error, boolean explain) throws IOException {
        builder.startObject();
        builder.field(VALID_FIELD, false);
        if (explain) {
            builder.field(ERROR_FIELD, error);
        }
        builder.endObject();
        return new BytesRestResponse(RestStatus.OK, builder);
    }
}

