/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain;

import java.util.Collection;
import java.util.Collections;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Accountable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.FieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.ScriptDocValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

abstract class AtomicDoubleFieldData
implements AtomicNumericFieldData {
    private final long ramBytesUsed;

    AtomicDoubleFieldData(long ramBytesUsed) {
        this.ramBytesUsed = ramBytesUsed;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public final ScriptDocValues getScriptValues() {
        return new ScriptDocValues.Doubles(this.getDoubleValues());
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getDoubleValues());
    }

    @Override
    public final SortedNumericDocValues getLongValues() {
        return FieldData.castToLong(this.getDoubleValues());
    }

    public static AtomicNumericFieldData empty(final int maxDoc) {
        return new AtomicDoubleFieldData(0L){

            @Override
            public SortedNumericDoubleValues getDoubleValues() {
                return FieldData.emptySortedNumericDoubles(maxDoc);
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        };
    }

    @Override
    public void close() {
    }
}

