/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.Analysis;

public class StemmerOverrideTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final StemmerOverrideFilter.StemmerOverrideMap overrideMap;

    public StemmerOverrideTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) throws IOException {
        super(indexSettings, name, settings);
        List<String> rules = Analysis.getWordList(env, settings, "rules");
        if (rules == null) {
            throw new IllegalArgumentException("stemmer override filter requires either `rules` or `rules_path` to be configured");
        }
        StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder(false);
        StemmerOverrideTokenFilterFactory.parseRules(rules, builder, "=>");
        this.overrideMap = builder.build();
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new StemmerOverrideFilter(tokenStream, this.overrideMap);
    }

    static void parseRules(List<String> rules, StemmerOverrideFilter.Builder builder, String mappingSep) {
        for (String rule : rules) {
            List<String> mapping = Strings.splitSmart(rule, mappingSep, false);
            if (mapping.size() != 2) {
                throw new RuntimeException("Invalid Keyword override Rule:" + rule);
            }
            String key = mapping.get(0).trim();
            String override = mapping.get(1).trim();
            if (key.isEmpty() || override.isEmpty()) {
                throw new RuntimeException("Invalid Keyword override Rule:" + rule);
            }
            builder.add(key, override);
        }
    }
}

