/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.get;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.get.GetResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.get.MultiGetItemResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Streamable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;

public class MultiGetResponse
extends ActionResponse
implements Iterable<MultiGetItemResponse>,
ToXContentObject {
    private MultiGetItemResponse[] responses;

    MultiGetResponse() {
    }

    public MultiGetResponse(MultiGetItemResponse[] responses) {
        this.responses = responses;
    }

    public MultiGetItemResponse[] getResponses() {
        return this.responses;
    }

    @Override
    public Iterator<MultiGetItemResponse> iterator() {
        return Arrays.stream(this.responses).iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("docs");
        for (MultiGetItemResponse response : this.responses) {
            if (response.isFailed()) {
                builder.startObject();
                Failure failure = response.getFailure();
                builder.field("_index", failure.getIndex());
                builder.field("_type", failure.getType());
                builder.field("_id", failure.getId());
                ElasticsearchException.generateFailureXContent(builder, params, failure.getFailure(), true);
                builder.endObject();
                continue;
            }
            GetResponse getResponse = response.getResponse();
            getResponse.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.responses = new MultiGetItemResponse[in.readVInt()];
        for (int i = 0; i < this.responses.length; ++i) {
            this.responses[i] = MultiGetItemResponse.readItemResponse(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.responses.length);
        for (MultiGetItemResponse response : this.responses) {
            response.writeTo(out);
        }
    }

    static final class Fields {
        static final String DOCS = "docs";
        static final String _INDEX = "_index";
        static final String _TYPE = "_type";
        static final String _ID = "_id";

        Fields() {
        }
    }

    public static class Failure
    implements Streamable {
        private String index;
        private String type;
        private String id;
        private Exception exception;

        Failure() {
        }

        public Failure(String index, String type, String id, Exception exception) {
            this.index = index;
            this.type = type;
            this.id = id;
            this.exception = exception;
        }

        public String getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.exception != null ? this.exception.getMessage() : null;
        }

        public static Failure readFailure(StreamInput in) throws IOException {
            Failure failure = new Failure();
            failure.readFrom(in);
            return failure;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.index = in.readString();
            this.type = in.readOptionalString();
            this.id = in.readString();
            this.exception = in.readException();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeOptionalString(this.type);
            out.writeString(this.id);
            out.writeException(this.exception);
        }

        public Exception getFailure() {
            return this.exception;
        }
    }
}

