/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.util.bkd;

import java.io.Closeable;
import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.LongBitSet;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.bkd.PointWriter;

public abstract class PointReader
implements Closeable {
    public abstract boolean next() throws IOException;

    public abstract byte[] packedValue();

    public abstract long ord();

    public abstract int docID();

    public void markOrds(long count, LongBitSet ordBitSet) throws IOException {
        int i = 0;
        while ((long)i < count) {
            boolean result = this.next();
            if (!result) {
                throw new IllegalStateException("did not see enough points from reader=" + this);
            }
            assert (!ordBitSet.get(this.ord())) : "ord=" + this.ord() + " was seen twice from " + this;
            ordBitSet.set(this.ord());
            ++i;
        }
    }

    public long split(long count, LongBitSet rightTree, PointWriter left, PointWriter right, boolean doClearBits) throws IOException {
        long rightCount = 0L;
        for (long i = 0L; i < count; ++i) {
            boolean result = this.next();
            assert (result);
            byte[] packedValue = this.packedValue();
            long ord = this.ord();
            int docID = this.docID();
            if (rightTree.get(ord)) {
                right.append(packedValue, ord, docID);
                ++rightCount;
                if (!doClearBits) continue;
                rightTree.clear(ord);
                continue;
            }
            left.append(packedValue, ord, docID);
        }
        return rightCount;
    }
}

