/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.function;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.FunctionValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.ValueSource;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Sort;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.FirstPassGroupingCollector;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.mutable.MutableValue;

public class FunctionFirstPassGroupingCollector
extends FirstPassGroupingCollector<MutableValue> {
    private final ValueSource groupByVS;
    private final Map<?, ?> vsContext;
    private FunctionValues.ValueFiller filler;
    private MutableValue mval;

    public FunctionFirstPassGroupingCollector(ValueSource groupByVS, Map<?, ?> vsContext, Sort groupSort, int topNGroups) throws IOException {
        super(groupSort, topNGroups);
        this.groupByVS = groupByVS;
        this.vsContext = vsContext;
    }

    @Override
    protected MutableValue getDocGroupValue(int doc) {
        this.filler.fillValue(doc);
        return this.mval;
    }

    @Override
    protected MutableValue copyDocGroupValue(MutableValue groupValue, MutableValue reuse) {
        if (reuse != null) {
            reuse.copy(groupValue);
            return reuse;
        }
        return groupValue.duplicate();
    }

    @Override
    protected void doSetNextReader(LeafReaderContext readerContext) throws IOException {
        super.doSetNextReader(readerContext);
        FunctionValues values = this.groupByVS.getValues(this.vsContext, readerContext);
        this.filler = values.getValueFiller();
        this.mval = this.filler.getValue();
    }
}

