/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.StoredFieldsFormat;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.StoredFieldsReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.StoredFieldsWriter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.compressing.CompressingStoredFieldsFormat;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.compressing.CompressionMode;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FieldInfos;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SegmentInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.Directory;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.IOContext;

public final class Lucene50StoredFieldsFormat
extends StoredFieldsFormat {
    public static final String MODE_KEY = Lucene50StoredFieldsFormat.class.getSimpleName() + ".mode";
    final Mode mode;

    public Lucene50StoredFieldsFormat() {
        this(Mode.BEST_SPEED);
    }

    public Lucene50StoredFieldsFormat(Mode mode) {
        this.mode = Objects.requireNonNull(mode);
    }

    @Override
    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        String value = si.getAttribute(MODE_KEY);
        if (value == null) {
            throw new IllegalStateException("missing value for " + MODE_KEY + " for segment: " + si.name);
        }
        Mode mode = Mode.valueOf(value);
        return this.impl(mode).fieldsReader(directory, si, fn, context);
    }

    @Override
    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        String previous = si.putAttribute(MODE_KEY, this.mode.name());
        if (previous != null && !previous.equals(this.mode.name())) {
            throw new IllegalStateException("found existing value for " + MODE_KEY + " for segment: " + si.name + "old=" + previous + ", new=" + this.mode.name());
        }
        return this.impl(this.mode).fieldsWriter(directory, si, context);
    }

    StoredFieldsFormat impl(Mode mode) {
        switch (mode) {
            case BEST_SPEED: {
                return new CompressingStoredFieldsFormat("Lucene50StoredFieldsFast", CompressionMode.FAST, 16384, 128, 1024);
            }
            case BEST_COMPRESSION: {
                return new CompressingStoredFieldsFormat("Lucene50StoredFieldsHigh", CompressionMode.HIGH_COMPRESSION, 61440, 512, 1024);
            }
        }
        throw new AssertionError();
    }

    public static enum Mode {
        BEST_SPEED,
        BEST_COMPRESSION;

    }
}

