/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.gl;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.gl.GalicianStemmer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

public final class GalicianStemFilter
extends TokenFilter {
    private final GalicianStemmer stemmer = new GalicianStemmer();
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public GalicianStemFilter(TokenStream input) {
        super(input);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                int len = this.termAtt.length();
                int newlen = this.stemmer.stem(this.termAtt.resizeBuffer(len + 1), len);
                this.termAtt.setLength(newlen);
            }
            return true;
        }
        return false;
    }
}

