/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc;

import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.BitMixer;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.HashOrderMixing;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.ObjectDoubleHashMap;

public class ObjectDoubleScatterMap<KType>
extends ObjectDoubleHashMap<KType> {
    public ObjectDoubleScatterMap() {
        this(4);
    }

    public ObjectDoubleScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectDoubleScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(KType key) {
        return BitMixer.mixPhi(key);
    }

    public static <KType> ObjectDoubleScatterMap<KType> from(KType[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectDoubleScatterMap<KType> map = new ObjectDoubleScatterMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

