/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.indices;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.GenericResultAbstractAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Analyze
extends GenericResultAbstractAction {
    protected Analyze(Builder builder) {
        super(builder);
        this.indexName = builder.index;
        this.payload = Collections.singletonMap("text", builder.textToAnalyze);
        ImmutableMap.Builder payloadBuilder = ImmutableMap.builder();
        payloadBuilder.put((Object)"text", (Object)builder.textToAnalyze);
        if (!Strings.isNullOrEmpty((String)builder.analyzer)) {
            payloadBuilder.put((Object)"analyzer", (Object)builder.analyzer);
        }
        if (!Strings.isNullOrEmpty((String)builder.field)) {
            payloadBuilder.put((Object)"field", (Object)builder.field);
        }
        if (!Strings.isNullOrEmpty((String)builder.tokenizer)) {
            payloadBuilder.put((Object)"tokenizer", (Object)builder.tokenizer);
        }
        if (builder.filter != null && !builder.filter.isEmpty()) {
            payloadBuilder.put((Object)"filter", (Object)builder.filter);
        }
        this.payload = payloadBuilder.build();
        this.setURI(this.buildURI());
    }

    @Override
    protected String buildURI() {
        return super.buildURI() + "/_analyze";
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    public static class Builder
    extends AbstractAction.Builder<Analyze, Builder> {
        private String index;
        private List<String> textToAnalyze = new ArrayList<String>();
        private String analyzer;
        private String field;
        private String tokenizer;
        private List<String> filter = new ArrayList<String>();

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder text(String textToAnalyze) {
            this.textToAnalyze.add(textToAnalyze);
            return this;
        }

        public Builder text(Collection<? extends String> textToAnalyze) {
            this.textToAnalyze.addAll(textToAnalyze);
            return this;
        }

        public Builder analyzer(String analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        public Builder tokenizer(String tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public Builder filter(String filter) {
            this.filter.add(filter);
            return this;
        }

        public Builder format(String format) {
            return (Builder)this.setParameter("format", format);
        }

        @Override
        public Analyze build() {
            return new Analyze(this);
        }
    }
}

