/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import io.searchbox.client.JestResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class CatResult
extends JestResult {
    public CatResult(CatResult catResult) {
        super(catResult);
    }

    public CatResult(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    public String[][] getPlainText() {
        ArrayNode esResultRows;
        JsonNode jsonObject = this.getJsonObject();
        if (jsonObject != null && jsonObject.has(this.getPathToResult()) && jsonObject.get(this.getPathToResult()).isArray() && (esResultRows = (ArrayNode)jsonObject.get(this.getPathToResult())).size() > 0 && esResultRows.get(0).isObject()) {
            return this.parseResultArray(esResultRows);
        }
        return new String[0][0];
    }

    private String[][] parseResultArray(ArrayNode esResponse) {
        JsonNode jsonNode = esResponse.get(0);
        ArrayList fieldsInFirstResponseRow = Lists.newArrayList((Iterator)jsonNode.fields());
        String[][] result = new String[esResponse.size() + 1][fieldsInFirstResponseRow.size()];
        for (int i = 0; i < fieldsInFirstResponseRow.size(); ++i) {
            result[0][i] = (String)((Map.Entry)fieldsInFirstResponseRow.get(i)).getKey();
        }
        int rowNum = 1;
        for (JsonNode row : esResponse) {
            for (int colId = 0; colId < fieldsInFirstResponseRow.size(); ++colId) {
                result[rowNum][colId] = row.get(result[0][colId]).asText();
            }
            ++rowNum;
        }
        return result;
    }
}

