/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client.http;

import com.google.common.base.Preconditions;
import io.searchbox.client.JestRetryHandler;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.SSLException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRetryHandler
implements JestRetryHandler<HttpUriRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpRetryHandler.class);
    private final int retryCount;
    private final Collection<Class<? extends Exception>> exceptionClasses;

    public HttpRetryHandler(int retryCount) {
        this(retryCount, Arrays.asList(UnknownHostException.class, ConnectException.class, ConnectionClosedException.class, SSLException.class));
    }

    public HttpRetryHandler(int retryCount, Collection<Class<? extends Exception>> exceptionClasses) {
        Preconditions.checkArgument((retryCount >= 0 ? 1 : 0) != 0, (Object)"retryCount must be positive");
        Preconditions.checkArgument((!exceptionClasses.isEmpty() ? 1 : 0) != 0, (Object)"exceptionClasses must not be empty");
        this.retryCount = retryCount;
        this.exceptionClasses = exceptionClasses;
    }

    @Override
    public boolean retryRequest(Exception exception, int executionCount, HttpUriRequest request) {
        if (executionCount >= this.retryCount) {
            log.debug("Maximum number of retries ({}) for request {} reached (executed {} times)", new Object[]{this.retryCount, request, executionCount, exception});
            return false;
        }
        for (Class<? extends Exception> exceptionClass : this.exceptionClasses) {
            if (!exceptionClass.isInstance(exception)) continue;
            log.debug("Retrying request {}", (Object)request, (Object)exception);
            return true;
        }
        log.debug("Not retrying request {} due to unsupported exception", (Object)request, (Object)exception);
        return false;
    }
}

