/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClientConfig {
    private Set<String> serverList;
    private boolean isMultiThreaded;
    private boolean isDiscoveryEnabled;
    private String discoveryFilter;
    private boolean isRequestCompressionEnabled;
    private int connTimeout;
    private int readTimeout;
    private long discoveryFrequency;
    private long maxConnectionIdleTime;
    private TimeUnit discoveryFrequencyTimeUnit;
    private TimeUnit maxConnectionIdleTimeDurationTimeUnit;
    private ObjectMapper objectMapper;
    private String defaultSchemeForDiscoveredNodes;

    private ClientConfig() {
    }

    public ClientConfig(AbstractBuilder builder) {
        this.serverList = builder.serverList;
        this.isMultiThreaded = builder.isMultiThreaded;
        this.isDiscoveryEnabled = builder.isDiscoveryEnabled;
        this.discoveryFilter = builder.discoveryFilter;
        this.isRequestCompressionEnabled = builder.isRequestCompressionEnabled;
        this.discoveryFrequency = builder.discoveryFrequency;
        this.discoveryFrequencyTimeUnit = builder.discoveryFrequencyTimeUnit;
        this.connTimeout = builder.connTimeout;
        this.readTimeout = builder.readTimeout;
        this.maxConnectionIdleTime = builder.maxConnectionIdleTime;
        this.maxConnectionIdleTimeDurationTimeUnit = builder.maxConnectionIdleTimeDurationTimeUnit;
        this.objectMapper = builder.objectMapper;
        this.defaultSchemeForDiscoveredNodes = builder.defaultSchemeForDiscoveredNodes;
    }

    public Set<String> getServerList() {
        return this.serverList;
    }

    public boolean isMultiThreaded() {
        return this.isMultiThreaded;
    }

    public boolean isDiscoveryEnabled() {
        return this.isDiscoveryEnabled;
    }

    public String getDiscoveryFilter() {
        return this.discoveryFilter;
    }

    public Long getDiscoveryFrequency() {
        return this.discoveryFrequency;
    }

    public TimeUnit getDiscoveryFrequencyTimeUnit() {
        return this.discoveryFrequencyTimeUnit;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public long getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    public TimeUnit getMaxConnectionIdleTimeDurationTimeUnit() {
        return this.maxConnectionIdleTimeDurationTimeUnit;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String getDefaultSchemeForDiscoveredNodes() {
        return this.defaultSchemeForDiscoveredNodes;
    }

    public boolean isRequestCompressionEnabled() {
        return this.isRequestCompressionEnabled;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.serverList, this.isMultiThreaded, this.isDiscoveryEnabled, this.isRequestCompressionEnabled, this.discoveryFrequency, this.discoveryFilter, this.connTimeout, this.readTimeout, this.discoveryFrequencyTimeUnit, this.maxConnectionIdleTime, this.maxConnectionIdleTimeDurationTimeUnit, this.objectMapper, this.defaultSchemeForDiscoveredNodes});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ClientConfig rhs = (ClientConfig)obj;
        return Objects.equals(this.serverList, rhs.serverList) && Objects.equals(this.isMultiThreaded, rhs.isMultiThreaded) && Objects.equals(this.isDiscoveryEnabled, rhs.isDiscoveryEnabled) && Objects.equals(this.isRequestCompressionEnabled, rhs.isRequestCompressionEnabled) && Objects.equals(this.discoveryFrequency, rhs.discoveryFrequency) && Objects.equals(this.discoveryFilter, rhs.discoveryFilter) && Objects.equals(this.connTimeout, rhs.connTimeout) && Objects.equals(this.readTimeout, rhs.readTimeout) && Objects.equals((Object)this.discoveryFrequencyTimeUnit, (Object)rhs.discoveryFrequencyTimeUnit) && Objects.equals(this.maxConnectionIdleTime, rhs.maxConnectionIdleTime) && Objects.equals((Object)this.maxConnectionIdleTimeDurationTimeUnit, (Object)rhs.maxConnectionIdleTimeDurationTimeUnit) && Objects.equals(this.objectMapper, rhs.objectMapper) && Objects.equals(this.defaultSchemeForDiscoveredNodes, rhs.defaultSchemeForDiscoveredNodes);
    }

    protected static abstract class AbstractBuilder<T extends ClientConfig, K extends AbstractBuilder<T, K>> {
        protected Set<String> serverList = new LinkedHashSet<String>();
        protected boolean isMultiThreaded;
        protected boolean isDiscoveryEnabled;
        protected String discoveryFilter;
        protected boolean isRequestCompressionEnabled;
        protected long discoveryFrequency = 10L;
        protected long maxConnectionIdleTime = -1L;
        protected Integer maxTotalConnection;
        protected Integer defaultMaxTotalConnectionPerRoute;
        protected Integer connTimeout = 3000;
        protected Integer readTimeout = 3000;
        protected TimeUnit discoveryFrequencyTimeUnit = TimeUnit.SECONDS;
        protected TimeUnit maxConnectionIdleTimeDurationTimeUnit = TimeUnit.SECONDS;
        protected ObjectMapper objectMapper;
        protected String defaultSchemeForDiscoveredNodes = "http://";

        public AbstractBuilder(Collection<String> serverUris) {
            this.serverList.addAll(serverUris);
        }

        public AbstractBuilder(String serverUri) {
            this.serverList.add(serverUri);
        }

        public AbstractBuilder(ClientConfig clientConfig) {
            this.serverList = clientConfig.serverList;
            this.isMultiThreaded = clientConfig.isMultiThreaded;
            this.isDiscoveryEnabled = clientConfig.isDiscoveryEnabled;
            this.discoveryFrequency = clientConfig.discoveryFrequency;
            this.discoveryFilter = clientConfig.discoveryFilter;
            this.discoveryFrequencyTimeUnit = clientConfig.discoveryFrequencyTimeUnit;
            this.connTimeout = clientConfig.connTimeout;
            this.readTimeout = clientConfig.readTimeout;
            this.objectMapper = clientConfig.objectMapper;
        }

        public K addServer(String serverUri) {
            this.serverList.add(serverUri);
            return (K)this;
        }

        public K addServer(Collection<String> serverUris) {
            this.serverList.addAll(serverUris);
            return (K)this;
        }

        public K objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return (K)this;
        }

        public K discoveryFrequency(long discoveryFrequency, TimeUnit discoveryFrequencyTimeUnit) {
            this.discoveryFrequency = discoveryFrequency;
            this.discoveryFrequencyTimeUnit = discoveryFrequencyTimeUnit;
            return (K)this;
        }

        public K discoveryEnabled(boolean isDiscoveryEnabled) {
            this.isDiscoveryEnabled = isDiscoveryEnabled;
            return (K)this;
        }

        public K discoveryFilter(String discoveryFilter) {
            this.discoveryFilter = discoveryFilter;
            return (K)this;
        }

        public K multiThreaded(boolean isMultiThreaded) {
            this.isMultiThreaded = isMultiThreaded;
            return (K)this;
        }

        public K requestCompressionEnabled(boolean isRequestCompressionEnabled) {
            this.isRequestCompressionEnabled = isRequestCompressionEnabled;
            return (K)this;
        }

        public K connTimeout(int connTimeout) {
            this.connTimeout = connTimeout;
            return (K)this;
        }

        public K readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return (K)this;
        }

        public K maxTotalConnection(int maxTotalConnection) {
            this.maxTotalConnection = maxTotalConnection;
            return (K)this;
        }

        public K defaultMaxTotalConnectionPerRoute(int defaultMaxTotalConnectionPerRoute) {
            this.defaultMaxTotalConnectionPerRoute = defaultMaxTotalConnectionPerRoute;
            return (K)this;
        }

        public K maxConnectionIdleTime(long duration, TimeUnit maxConnectionIdleTimeDurationTimeUnit) {
            this.maxConnectionIdleTime = duration;
            this.maxConnectionIdleTimeDurationTimeUnit = maxConnectionIdleTimeDurationTimeUnit;
            return (K)this;
        }

        public K defaultSchemeForDiscoveredNodes(String defaultSchemeForDiscoveredNodes) {
            this.defaultSchemeForDiscoveredNodes = defaultSchemeForDiscoveredNodes + "://";
            return (K)this;
        }

        public abstract T build();
    }

    public static class Builder
    extends AbstractBuilder<ClientConfig, Builder> {
        public Builder(ClientConfig clientConfig) {
            super(clientConfig);
        }

        public Builder(Collection<String> serverUris) {
            super(serverUris);
        }

        public Builder(String serverUri) {
            super(serverUri);
        }

        @Override
        public ClientConfig build() {
            return new ClientConfig(this);
        }
    }
}

