/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.InternalMax;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.metrics.Percentile;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.pipeline.PercentilesBucket;

public class InternalPercentilesBucket
extends InternalNumericMetricsAggregation.MultiValue
implements PercentilesBucket {
    private double[] percentiles;
    private double[] percents;
    private boolean keyed = true;
    private final transient Map<Double, Double> percentileLookups = new HashMap<Double, Double>();

    InternalPercentilesBucket(String name, double[] percents, double[] percentiles, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, metadata);
        if (!(percentiles.length == percents.length)) {
            throw new IllegalArgumentException("The number of provided percents and percentiles didn't match. percents: " + Arrays.toString(percents) + ", percentiles: " + Arrays.toString(percentiles));
        }
        this.format = formatter;
        this.percentiles = percentiles;
        this.percents = percents;
        this.keyed = keyed;
        this.computeLookup();
    }

    private void computeLookup() {
        for (int i = 0; i < this.percents.length; ++i) {
            this.percentileLookups.put(this.percents[i], this.percentiles[i]);
        }
    }

    public InternalPercentilesBucket(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.percentiles = in.readDoubleArray();
        this.percents = in.readDoubleArray();
        if (in.getVersion().onOrAfter(Version.V_7_0_0)) {
            this.keyed = in.readBoolean();
        }
        this.computeLookup();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDoubleArray(this.percentiles);
        out.writeDoubleArray(this.percents);
        if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
            out.writeBoolean(this.keyed);
        }
    }

    @Override
    public String getWriteableName() {
        return "percentiles_bucket";
    }

    @Override
    public double percentile(double percent) throws IllegalArgumentException {
        Double percentile = this.percentileLookups.get(percent);
        if (percentile == null) {
            throw new IllegalArgumentException("Percent requested [" + String.valueOf(percent) + "] was not one of the computed percentiles.  Available keys are: " + Arrays.toString(this.percents));
        }
        return percentile;
    }

    @Override
    public String percentileAsString(double percent) {
        return this.format.format(this.percentile(percent)).toString();
    }

    DocValueFormat formatter() {
        return this.format;
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iter(this.percents, this.percentiles);
    }

    @Override
    public double value(String name) {
        return this.percentile(Double.parseDouble(name));
    }

    @Override
    public InternalMax reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject("values");
            for (double percent : this.percents) {
                double value = this.percentile(percent);
                boolean hasValue = !Double.isInfinite(value) && !Double.isNaN(value);
                String key = String.valueOf(percent);
                builder.field(key, hasValue ? Double.valueOf(value) : null);
                if (!hasValue || this.format == DocValueFormat.RAW) continue;
                builder.field(key + "_as_string", this.percentileAsString(percent));
            }
            builder.endObject();
        } else {
            builder.startArray("values");
            for (double percent : this.percents) {
                double value = this.percentile(percent);
                boolean hasValue = !Double.isInfinite(value) && !Double.isNaN(value);
                builder.startObject();
                builder.field("key", percent);
                builder.field("value", hasValue ? Double.valueOf(value) : null);
                if (hasValue && this.format != DocValueFormat.RAW) {
                    builder.field(String.valueOf(percent) + "_as_string", this.percentileAsString(percent));
                }
                builder.endObject();
            }
            builder.endArray();
        }
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalPercentilesBucket that = (InternalPercentilesBucket)obj;
        return Arrays.equals(this.percents, that.percents) && Arrays.equals(this.percentiles, that.percentiles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.percents), Arrays.hashCode(this.percentiles));
    }

    public static class Iter
    implements Iterator<Percentile> {
        private final double[] percents;
        private final double[] percentiles;
        private int i;

        public Iter(double[] percents, double[] percentiles) {
            this.percents = percents;
            this.percentiles = percentiles;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.percents.length;
        }

        @Override
        public Percentile next() {
            Percentile next = new Percentile(this.percents[this.i], this.percentiles[this.i]);
            ++this.i;
            return next;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

