/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.CollectionUtil;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasables;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.BucketOrder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.internal.SearchContext;

public abstract class AbstractHistogramAggregator
extends BucketsAggregator {
    protected final DocValueFormat formatter;
    protected final double interval;
    protected final double offset;
    protected final BucketOrder order;
    protected final boolean keyed;
    protected final long minDocCount;
    protected final double minBound;
    protected final double maxBound;
    protected final LongKeyedBucketOrds bucketOrds;

    public AbstractHistogramAggregator(String name, AggregatorFactories factories, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, double minBound, double maxBound, DocValueFormat formatter, SearchContext context, Aggregator parent, CardinalityUpperBound cardinalityUpperBound, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, CardinalityUpperBound.MANY, metadata);
        if (interval <= 0.0) {
            throw new IllegalArgumentException("interval must be positive, got: " + interval);
        }
        this.interval = interval;
        this.offset = offset;
        this.order = order;
        order.validate(this);
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.minBound = minBound;
        this.maxBound = maxBound;
        this.formatter = formatter;
        this.bucketOrds = LongKeyedBucketOrds.build(context.bigArrays(), cardinalityUpperBound);
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForVariableBuckets(owningBucketOrds, this.bucketOrds, (bucketValue, docCount, subAggregationResults) -> {
            double roundKey = Double.longBitsToDouble(bucketValue);
            double key = roundKey * this.interval + this.offset;
            return new InternalHistogram.Bucket(key, docCount, this.keyed, this.formatter, subAggregationResults);
        }, (owningBucketOrd, buckets) -> {
            CollectionUtil.introSort(buckets, BucketOrder.key(true).comparator());
            InternalHistogram.EmptyBucketInfo emptyBucketInfo = null;
            if (this.minDocCount == 0L) {
                emptyBucketInfo = new InternalHistogram.EmptyBucketInfo(this.interval, this.offset, this.minBound, this.maxBound, this.buildEmptySubAggregations());
            }
            return new InternalHistogram(this.name, buckets, this.order, this.minDocCount, emptyBucketInfo, this.formatter, this.keyed, this.metadata());
        });
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalHistogram.EmptyBucketInfo emptyBucketInfo = null;
        if (this.minDocCount == 0L) {
            emptyBucketInfo = new InternalHistogram.EmptyBucketInfo(this.interval, this.offset, this.minBound, this.maxBound, this.buildEmptySubAggregations());
        }
        return new InternalHistogram(this.name, Collections.emptyList(), this.order, this.minDocCount, emptyBucketInfo, this.formatter, this.keyed, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        add.accept("total_buckets", this.bucketOrds.size());
        super.collectDebugInfo(add);
    }
}

