/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.cat;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.ObjectIntScatterMap;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Table;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.ByteSizeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.RestActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.RestResponseListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.cat.RestTable;

public class RestAllocationAction
extends AbstractCatAction {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/allocation"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/allocation/{nodes}")));
    }

    @Override
    public String getName() {
        return "cat_allocation_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/allocation\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, final NodeClient client) {
        final String[] nodes = Strings.splitStringByCommaToArray(request.param("nodes", "data:true"));
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().routingTable(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new RestActionListener<ClusterStateResponse>(channel){

            @Override
            public void processResponse(final ClusterStateResponse state) {
                NodesStatsRequest statsRequest = new NodesStatsRequest(nodes);
                statsRequest.clear().addMetric(NodesStatsRequest.Metric.FS.metricName()).indices(new CommonStatsFlags(CommonStatsFlags.Flag.Store));
                client.admin().cluster().nodesStats(statsRequest, (ActionListener<NodesStatsResponse>)new RestResponseListener<NodesStatsResponse>(this.channel){

                    @Override
                    public RestResponse buildResponse(NodesStatsResponse stats) throws Exception {
                        Table tab = RestAllocationAction.this.buildTable(request, state, stats);
                        return RestTable.buildResponse(tab, this.channel);
                    }
                });
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("shards", "alias:s;text-align:right;desc:number of shards on node");
        table.addCell("disk.indices", "alias:di,diskIndices;text-align:right;desc:disk used by ES indices");
        table.addCell("disk.used", "alias:du,diskUsed;text-align:right;desc:disk used (total, not just ES)");
        table.addCell("disk.avail", "alias:da,diskAvail;text-align:right;desc:disk available");
        table.addCell("disk.total", "alias:dt,diskTotal;text-align:right;desc:total capacity of all volumes");
        table.addCell("disk.percent", "alias:dp,diskPercent;text-align:right;desc:percent disk used");
        table.addCell("host", "alias:h;desc:host of node");
        table.addCell("ip", "desc:ip of node");
        table.addCell("node", "alias:n;desc:name of node");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, ClusterStateResponse state, NodesStatsResponse stats) {
        ObjectIntScatterMap<String> allocs = new ObjectIntScatterMap<String>();
        for (ShardRouting shardRouting : state.getState().routingTable().allShards()) {
            String nodeId = "UNASSIGNED";
            if (shardRouting.assignedToNode()) {
                nodeId = shardRouting.currentNodeId();
            }
            allocs.addTo(nodeId, 1);
        }
        Table table = this.getTableWithHeader(request);
        for (NodeStats nodeStats : stats.getNodes()) {
            DiscoveryNode node = nodeStats.getNode();
            int shardCount = allocs.getOrDefault(node.getId(), 0);
            ByteSizeValue total = nodeStats.getFs().getTotal().getTotal();
            ByteSizeValue avail = nodeStats.getFs().getTotal().getAvailable();
            long used = 0L;
            short diskPercent = -1;
            if (total.getBytes() > 0L && (used = total.getBytes() - avail.getBytes()) >= 0L && avail.getBytes() >= 0L) {
                diskPercent = (short)(used * 100L / (used + avail.getBytes()));
            }
            table.startRow();
            table.addCell(shardCount);
            table.addCell(nodeStats.getIndices().getStore().getSize());
            table.addCell(used < 0L ? null : new ByteSizeValue(used));
            table.addCell(avail.getBytes() < 0L ? null : avail);
            table.addCell(total.getBytes() < 0L ? null : total);
            table.addCell(diskPercent < 0 ? null : Short.valueOf(diskPercent));
            table.addCell(node.getHostName());
            table.addCell(node.getHostAddress());
            table.addCell(node.getName());
            table.endRow();
        }
        String string = "UNASSIGNED";
        if (allocs.containsKey("UNASSIGNED")) {
            table.startRow();
            table.addCell(allocs.get("UNASSIGNED"));
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell(null);
            table.addCell("UNASSIGNED");
            table.endRow();
        }
        return table;
    }
}

