/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.rest;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestRequest;

final class MethodHandlers {
    private final String path;
    private final Map<RestRequest.Method, RestHandler> methodHandlers;

    MethodHandlers(String path, RestHandler handler, RestRequest.Method ... methods) {
        this.path = path;
        this.methodHandlers = new HashMap<RestRequest.Method, RestHandler>(methods.length);
        for (RestRequest.Method method : methods) {
            this.methodHandlers.put(method, handler);
        }
    }

    MethodHandlers addMethods(RestHandler handler, RestRequest.Method ... methods) {
        for (RestRequest.Method method : methods) {
            RestHandler existing = this.methodHandlers.putIfAbsent(method, handler);
            if (existing == null) continue;
            throw new IllegalArgumentException("Cannot replace existing handler for [" + this.path + "] for method: " + (Object)((Object)method));
        }
        return this;
    }

    @Nullable
    RestHandler getHandler(RestRequest.Method method) {
        return this.methodHandlers.get((Object)method);
    }

    Set<RestRequest.Method> getValidMethods() {
        return this.methodHandlers.keySet();
    }
}

