/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DirectoryReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.OrdinalMap;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SortedSetSelector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SortedSetSortField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.BigArrays;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.Index;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.IndexSettings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.ScriptDocValues;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsIndexFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fielddata.plain.SortedSetBytesLeafFieldData;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MapperService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.MultiValueMode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.BucketedSort;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortOrder;

public class SortedSetOrdinalsIndexFieldData
implements IndexOrdinalsFieldData {
    protected final Index index;
    protected final String fieldName;
    private final IndexSettings indexSettings;
    private final IndexFieldDataCache cache;
    private final CircuitBreakerService breakerService;
    private final Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction;
    private final ValuesSourceType valuesSourceType;
    private static final Logger logger = LogManager.getLogger(SortedSetOrdinalsIndexFieldData.class);

    public SortedSetOrdinalsIndexFieldData(IndexSettings indexSettings, IndexFieldDataCache cache, String fieldName, ValuesSourceType valuesSourceType, CircuitBreakerService breakerService, Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction) {
        this.index = indexSettings.getIndex();
        this.fieldName = fieldName;
        this.valuesSourceType = valuesSourceType;
        this.indexSettings = indexSettings;
        this.cache = cache;
        this.breakerService = breakerService;
        this.scriptFunction = scriptFunction;
    }

    @Override
    public final String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    public final void clear() {
    }

    @Override
    public final Index index() {
        return this.index;
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        if (nested != null || sortMode != MultiValueMode.MAX && sortMode != MultiValueMode.MIN || !source.sortMissingLast(missingValue) && !source.sortMissingFirst(missingValue)) {
            return new SortField(this.getFieldName(), source, reverse);
        }
        SortedSetSortField sortField = new SortedSetSortField(this.fieldName, reverse, sortMode == MultiValueMode.MAX ? SortedSetSelector.Type.MAX : SortedSetSelector.Type.MIN);
        ((SortField)sortField).setMissingValue(source.sortMissingLast(missingValue) ^ reverse ? SortedSetSortField.STRING_LAST : SortedSetSortField.STRING_FIRST);
        return sortField;
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    @Override
    public LeafOrdinalsFieldData load(LeafReaderContext context) {
        return new SortedSetBytesLeafFieldData(context.reader(), this.fieldName, this.scriptFunction);
    }

    @Override
    public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
        IndexOrdinalsFieldData fieldData = this.loadGlobalInternal(indexReader);
        if (fieldData instanceof GlobalOrdinalsIndexFieldData) {
            return ((GlobalOrdinalsIndexFieldData)fieldData).newConsumer(indexReader);
        }
        return fieldData;
    }

    private IndexOrdinalsFieldData loadGlobalInternal(DirectoryReader indexReader) {
        if (indexReader.leaves().size() <= 1) {
            return this;
        }
        boolean fieldFound = false;
        for (LeafReaderContext context : indexReader.leaves()) {
            if (context.reader().getFieldInfos().fieldInfo(this.getFieldName()) == null) continue;
            fieldFound = true;
            break;
        }
        if (!fieldFound) {
            try {
                return GlobalOrdinalsBuilder.buildEmpty(this.indexSettings, indexReader, this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return this.cache.load(indexReader, this);
        }
        catch (Exception e) {
            if (e instanceof ElasticsearchException) {
                throw (ElasticsearchException)e;
            }
            throw new ElasticsearchException(e);
        }
    }

    @Override
    public IndexOrdinalsFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
        return GlobalOrdinalsBuilder.build(indexReader, this, this.indexSettings, this.breakerService, logger, this.scriptFunction);
    }

    @Override
    public OrdinalMap getOrdinalMap() {
        return null;
    }

    @Override
    public boolean supportsGlobalOrdinalsMapping() {
        return true;
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction;
        private final ValuesSourceType valuesSourceType;

        public Builder(ValuesSourceType valuesSourceType) {
            this(AbstractLeafOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION, valuesSourceType);
        }

        public Builder(Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction, ValuesSourceType valuesSourceType) {
            this.scriptFunction = scriptFunction;
            this.valuesSourceType = valuesSourceType;
        }

        public SortedSetOrdinalsIndexFieldData build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            String fieldName = fieldType.name();
            return new SortedSetOrdinalsIndexFieldData(indexSettings, cache, fieldName, this.valuesSourceType, breakerService, this.scriptFunction);
        }
    }
}

