/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.Optional;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.coordination.Join;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.coordination.PublishResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportResponse;

public class PublishWithJoinResponse
extends TransportResponse {
    private final PublishResponse publishResponse;
    private final Optional<Join> optionalJoin;

    public PublishWithJoinResponse(PublishResponse publishResponse, Optional<Join> optionalJoin) {
        this.publishResponse = publishResponse;
        this.optionalJoin = optionalJoin;
    }

    public PublishWithJoinResponse(StreamInput in) throws IOException {
        this.publishResponse = new PublishResponse(in);
        this.optionalJoin = Optional.ofNullable(in.readOptionalWriteable(Join::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.publishResponse.writeTo(out);
        out.writeOptionalWriteable(this.optionalJoin.orElse(null));
    }

    public PublishResponse getPublishResponse() {
        return this.publishResponse;
    }

    public Optional<Join> getJoin() {
        return this.optionalJoin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishWithJoinResponse)) {
            return false;
        }
        PublishWithJoinResponse that = (PublishWithJoinResponse)o;
        if (!this.publishResponse.equals(that.publishResponse)) {
            return false;
        }
        return this.optionalJoin.equals(that.optionalJoin);
    }

    public int hashCode() {
        int result = this.publishResponse.hashCode();
        result = 31 * result + this.optionalJoin.hashCode();
        return result;
    }

    public String toString() {
        return "PublishWithJoinResponse{publishResponse=" + this.publishResponse + ", optionalJoin=" + this.optionalJoin + '}';
    }
}

