/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.transform;

import java.util.Objects;
import java.util.Optional;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Validatable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ValidationException;

public class DeleteTransformRequest
implements Validatable {
    public static final String FORCE = "force";
    private final String id;
    private Boolean force;

    public DeleteTransformRequest(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.id == null) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("transform id must not be null");
            return Optional.of(validationException);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.force);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteTransformRequest other = (DeleteTransformRequest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.force, other.force);
    }
}

