/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search;

import java.util.stream.Stream;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchPhaseResults;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.AtomicArray;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchPhaseResult;

class ArraySearchPhaseResults<Result extends SearchPhaseResult>
extends SearchPhaseResults<Result> {
    final AtomicArray<Result> results;

    ArraySearchPhaseResults(int size) {
        super(size);
        this.results = new AtomicArray(size);
    }

    @Override
    Stream<Result> getSuccessfulResults() {
        return this.results.asList().stream();
    }

    @Override
    void consumeResult(Result result) {
        assert (this.results.get(((SearchPhaseResult)result).getShardIndex()) == null) : "shardIndex: " + ((SearchPhaseResult)result).getShardIndex() + " is already set";
        this.results.set(((SearchPhaseResult)result).getShardIndex(), result);
    }

    @Override
    boolean hasResult(int shardIndex) {
        return this.results.get(shardIndex) != null;
    }

    @Override
    AtomicArray<Result> getAtomicArray() {
        return this.results;
    }
}

