/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;

public class FieldCapabilities
implements Writeable,
ToXContentObject {
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField SEARCHABLE_FIELD = new ParseField("searchable", new String[0]);
    private static final ParseField AGGREGATABLE_FIELD = new ParseField("aggregatable", new String[0]);
    private static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    private static final ParseField NON_SEARCHABLE_INDICES_FIELD = new ParseField("non_searchable_indices", new String[0]);
    private static final ParseField NON_AGGREGATABLE_INDICES_FIELD = new ParseField("non_aggregatable_indices", new String[0]);
    private static final ParseField META_FIELD = new ParseField("meta", new String[0]);
    private final String name;
    private final String type;
    private final boolean isSearchable;
    private final boolean isAggregatable;
    private final String[] indices;
    private final String[] nonSearchableIndices;
    private final String[] nonAggregatableIndices;
    private final Map<String, Set<String>> meta;
    private static final ConstructingObjectParser<FieldCapabilities, String> PARSER = new ConstructingObjectParser<FieldCapabilities, String>("field_capabilities", true, (a, name) -> new FieldCapabilities((String)name, (String)a[0], (Boolean)a[1], (Boolean)a[2], a[3] != null ? ((List)a[3]).toArray(new String[0]) : null, a[4] != null ? ((List)a[4]).toArray(new String[0]) : null, a[5] != null ? ((List)a[5]).toArray(new String[0]) : null, a[6] != null ? (Map)a[6] : Collections.emptyMap()));

    public FieldCapabilities(String name, String type, boolean isSearchable, boolean isAggregatable, String[] indices, String[] nonSearchableIndices, String[] nonAggregatableIndices, Map<String, Set<String>> meta) {
        this.name = name;
        this.type = type;
        this.isSearchable = isSearchable;
        this.isAggregatable = isAggregatable;
        this.indices = indices;
        this.nonSearchableIndices = nonSearchableIndices;
        this.nonAggregatableIndices = nonAggregatableIndices;
        this.meta = Objects.requireNonNull(meta);
    }

    FieldCapabilities(StreamInput in) throws IOException {
        this.name = in.readString();
        this.type = in.readString();
        this.isSearchable = in.readBoolean();
        this.isAggregatable = in.readBoolean();
        this.indices = in.readOptionalStringArray();
        this.nonSearchableIndices = in.readOptionalStringArray();
        this.nonAggregatableIndices = in.readOptionalStringArray();
        this.meta = in.getVersion().onOrAfter(Version.V_7_6_0) ? in.readMap(StreamInput::readString, i -> i.readSet(StreamInput::readString)) : Collections.emptyMap();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeBoolean(this.isSearchable);
        out.writeBoolean(this.isAggregatable);
        out.writeOptionalStringArray(this.indices);
        out.writeOptionalStringArray(this.nonSearchableIndices);
        out.writeOptionalStringArray(this.nonAggregatableIndices);
        if (out.getVersion().onOrAfter(Version.V_7_6_0)) {
            out.writeMap(this.meta, StreamOutput::writeString, (o, set) -> o.writeCollection(set, StreamOutput::writeString));
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TYPE_FIELD.getPreferredName(), this.type);
        builder.field(SEARCHABLE_FIELD.getPreferredName(), this.isSearchable);
        builder.field(AGGREGATABLE_FIELD.getPreferredName(), this.isAggregatable);
        if (this.indices != null) {
            builder.field(INDICES_FIELD.getPreferredName(), this.indices);
        }
        if (this.nonSearchableIndices != null) {
            builder.field(NON_SEARCHABLE_INDICES_FIELD.getPreferredName(), this.nonSearchableIndices);
        }
        if (this.nonAggregatableIndices != null) {
            builder.field(NON_AGGREGATABLE_INDICES_FIELD.getPreferredName(), this.nonAggregatableIndices);
        }
        if (!this.meta.isEmpty()) {
            builder.startObject("meta");
            ArrayList<Map.Entry<String, Set<String>>> entries = new ArrayList<Map.Entry<String, Set<String>>>(this.meta.entrySet());
            entries.sort(Comparator.comparing(Map.Entry::getKey));
            for (Map.Entry entry : entries) {
                ArrayList values = new ArrayList((Collection)entry.getValue());
                values.sort(String::compareTo);
                builder.field((String)entry.getKey(), values);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static FieldCapabilities fromXContent(String name, XContentParser parser) throws IOException {
        return PARSER.parse(parser, name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isAggregatable() {
        return this.isAggregatable;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public String getType() {
        return this.type;
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] nonSearchableIndices() {
        return this.nonSearchableIndices;
    }

    public String[] nonAggregatableIndices() {
        return this.nonAggregatableIndices;
    }

    public Map<String, Set<String>> meta() {
        return this.meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilities that = (FieldCapabilities)o;
        return this.isSearchable == that.isSearchable && this.isAggregatable == that.isAggregatable && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Arrays.equals(this.indices, that.indices) && Arrays.equals(this.nonSearchableIndices, that.nonSearchableIndices) && Arrays.equals(this.nonAggregatableIndices, that.nonAggregatableIndices) && Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.type, this.isSearchable, this.isAggregatable, this.meta);
        result = 31 * result + Arrays.hashCode(this.indices);
        result = 31 * result + Arrays.hashCode(this.nonSearchableIndices);
        result = 31 * result + Arrays.hashCode(this.nonAggregatableIndices);
        return result;
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), SEARCHABLE_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), AGGREGATABLE_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), INDICES_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), NON_SEARCHABLE_INDICES_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), NON_AGGREGATABLE_INDICES_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, context) -> parser.map(HashMap::new, p -> Collections.unmodifiableSet(new HashSet<Object>(p.list()))), META_FIELD);
    }

    private static class IndexCaps {
        final String name;
        final boolean isSearchable;
        final boolean isAggregatable;

        IndexCaps(String name, boolean isSearchable, boolean isAggregatable) {
            this.name = name;
            this.isSearchable = isSearchable;
            this.isAggregatable = isAggregatable;
        }
    }

    static class Builder {
        private String name;
        private String type;
        private boolean isSearchable;
        private boolean isAggregatable;
        private List<IndexCaps> indiceList;
        private Map<String, Set<String>> meta;

        Builder(String name, String type) {
            this.name = name;
            this.type = type;
            this.isSearchable = true;
            this.isAggregatable = true;
            this.indiceList = new ArrayList<IndexCaps>();
            this.meta = new HashMap<String, Set<String>>();
        }

        void add(String index, boolean search, boolean agg, Map<String, String> meta) {
            IndexCaps indexCaps = new IndexCaps(index, search, agg);
            this.indiceList.add(indexCaps);
            this.isSearchable &= search;
            this.isAggregatable &= agg;
            for (Map.Entry<String, String> entry : meta.entrySet()) {
                this.meta.computeIfAbsent(entry.getKey(), key -> new HashSet()).add(entry.getValue());
            }
        }

        List<String> getIndices() {
            return this.indiceList.stream().map(c -> c.name).collect(Collectors.toList());
        }

        FieldCapabilities build(boolean withIndices) {
            Collections.sort(this.indiceList, Comparator.comparing(o -> o.name));
            String[] indices = withIndices ? (String[])this.indiceList.stream().map(caps -> caps.name).toArray(String[]::new) : null;
            String[] nonSearchableIndices = !this.isSearchable && this.indiceList.stream().anyMatch(caps -> caps.isSearchable) ? (String[])this.indiceList.stream().filter(caps -> !caps.isSearchable).map(caps -> caps.name).toArray(String[]::new) : null;
            String[] nonAggregatableIndices = !this.isAggregatable && this.indiceList.stream().anyMatch(caps -> caps.isAggregatable) ? (String[])this.indiceList.stream().filter(caps -> !caps.isAggregatable).map(caps -> caps.name).toArray(String[]::new) : null;
            Function<Map.Entry, Set> entryValueFunction = Map.Entry::getValue;
            Map<String, Set<String>> immutableMeta = Collections.unmodifiableMap(this.meta.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entryValueFunction.andThen(HashSet::new).andThen(Collections::unmodifiableSet))));
            return new FieldCapabilities(this.name, this.type, this.isSearchable, this.isAggregatable, indices, nonSearchableIndices, nonAggregatableIndices, immutableMeta);
        }
    }
}

