/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.store;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.ByteBuffersDataInput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.RandomAccessInput;

public final class ByteBuffersIndexInput
extends IndexInput
implements RandomAccessInput {
    private ByteBuffersDataInput in;

    public ByteBuffersIndexInput(ByteBuffersDataInput in, String resourceDescription) {
        super(resourceDescription);
        this.in = in;
    }

    @Override
    public void close() throws IOException {
        this.in = null;
    }

    @Override
    public long getFilePointer() {
        this.ensureOpen();
        return this.in.position();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.ensureOpen();
        this.in.seek(pos);
    }

    @Override
    public long length() {
        this.ensureOpen();
        return this.in.size();
    }

    @Override
    public ByteBuffersIndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        this.ensureOpen();
        return new ByteBuffersIndexInput(this.in.slice(offset, length), "(sliced) offset=" + offset + ", length=" + length + " " + this.toString() + " [slice=" + sliceDescription + "]");
    }

    @Override
    public byte readByte() throws IOException {
        this.ensureOpen();
        return this.in.readByte();
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.ensureOpen();
        this.in.readBytes(b, offset, len);
    }

    @Override
    public RandomAccessInput randomAccessSlice(long offset, long length) throws IOException {
        this.ensureOpen();
        return this.slice("", offset, length);
    }

    @Override
    public void readBytes(byte[] b, int offset, int len, boolean useBuffer) throws IOException {
        this.ensureOpen();
        this.in.readBytes(b, offset, len, useBuffer);
    }

    @Override
    public short readShort() throws IOException {
        this.ensureOpen();
        return this.in.readShort();
    }

    @Override
    public int readInt() throws IOException {
        this.ensureOpen();
        return this.in.readInt();
    }

    @Override
    public int readVInt() throws IOException {
        this.ensureOpen();
        return this.in.readVInt();
    }

    @Override
    public int readZInt() throws IOException {
        this.ensureOpen();
        return this.in.readZInt();
    }

    @Override
    public long readLong() throws IOException {
        this.ensureOpen();
        return this.in.readLong();
    }

    @Override
    public long readVLong() throws IOException {
        this.ensureOpen();
        return this.in.readVLong();
    }

    @Override
    public long readZLong() throws IOException {
        this.ensureOpen();
        return this.in.readZLong();
    }

    @Override
    public String readString() throws IOException {
        this.ensureOpen();
        return this.in.readString();
    }

    @Override
    public Map<String, String> readMapOfStrings() throws IOException {
        this.ensureOpen();
        return this.in.readMapOfStrings();
    }

    @Override
    public Set<String> readSetOfStrings() throws IOException {
        this.ensureOpen();
        return this.in.readSetOfStrings();
    }

    @Override
    public void skipBytes(long numBytes) throws IOException {
        this.ensureOpen();
        super.skipBytes(numBytes);
    }

    @Override
    public byte readByte(long pos) throws IOException {
        this.ensureOpen();
        return this.in.readByte(pos);
    }

    @Override
    public short readShort(long pos) throws IOException {
        this.ensureOpen();
        return this.in.readShort(pos);
    }

    @Override
    public int readInt(long pos) throws IOException {
        this.ensureOpen();
        return this.in.readInt(pos);
    }

    @Override
    public long readLong(long pos) throws IOException {
        this.ensureOpen();
        return this.in.readLong(pos);
    }

    @Override
    public IndexInput clone() {
        this.ensureOpen();
        ByteBuffersIndexInput cloned = new ByteBuffersIndexInput(this.in.slice(0L, this.in.size()), "(clone of) " + this.toString());
        try {
            cloned.seek(this.getFilePointer());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return cloned;
    }

    private void ensureOpen() {
        if (this.in == null) {
            throw new AlreadyClosedException("Already closed.");
        }
    }
}

