/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.similarities;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Explanation;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.similarities.BasicStats;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.similarities.Normalization;

public class NormalizationZ
extends Normalization {
    final float z;

    public NormalizationZ() {
        this(0.3f);
    }

    public NormalizationZ(float z) {
        if (Float.isNaN(z) || z <= 0.0f || z >= 0.5f) {
            throw new IllegalArgumentException("illegal z value: " + z + ", must be in the range (0 .. 0.5)");
        }
        this.z = z;
    }

    @Override
    public double tfn(BasicStats stats, double tf, double len) {
        return tf * Math.pow(stats.avgFieldLength / len, this.z);
    }

    @Override
    public Explanation explain(BasicStats stats, double tf, double len) {
        return Explanation.match((Number)Float.valueOf((float)this.tfn(stats, tf, len)), this.getClass().getSimpleName() + ", computed as tf * Math.pow(avgfl / fl, z) from:", Explanation.match((Number)Float.valueOf((float)tf), "tf, number of occurrences of term in the document", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)stats.getAvgFieldLength()), "avgfl, average length of field across all documents", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)len), "fl, field length of the document", new Explanation[0]), Explanation.match((Number)Float.valueOf(this.z), "z, relates to specificity of the language", new Explanation[0]));
    }

    @Override
    public String toString() {
        return "Z(" + this.z + ")";
    }

    public float getZ() {
        return this.z;
    }
}

