/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.highlight;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

final class LimitTokenOffsetFilter
extends TokenFilter {
    private final OffsetAttribute offsetAttrib = this.addAttribute(OffsetAttribute.class);
    private int maxStartOffset;

    LimitTokenOffsetFilter(TokenStream input, int maxStartOffset) {
        super(input);
        if (maxStartOffset < 0) {
            throw new IllegalArgumentException("maxStartOffset must be >= zero");
        }
        this.maxStartOffset = maxStartOffset;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        return this.offsetAttrib.startOffset() <= this.maxStartOffset;
    }
}

