/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DoubleValuesSource;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.LongValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.LongValuesSource;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorable;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.GroupSelector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.LongRange;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.LongRangeFactory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.grouping.SearchGroup;

public class LongRangeGroupSelector
extends GroupSelector<LongRange> {
    private final LongValuesSource source;
    private final LongRangeFactory rangeFactory;
    private Set<LongRange> inSecondPass;
    private boolean includeEmpty = true;
    private boolean positioned;
    private LongRange current;
    private LeafReaderContext context;
    private LongValues values;

    public LongRangeGroupSelector(LongValuesSource source, LongRangeFactory rangeFactory) {
        this.source = source;
        this.rangeFactory = rangeFactory;
    }

    @Override
    public void setNextReader(LeafReaderContext readerContext) throws IOException {
        this.context = readerContext;
    }

    @Override
    public void setScorer(Scorable scorer) throws IOException {
        this.values = this.source.getValues(this.context, DoubleValuesSource.fromScorer(scorer));
    }

    @Override
    public GroupSelector.State advanceTo(int doc) throws IOException {
        this.positioned = this.values.advanceExact(doc);
        if (!this.positioned) {
            return this.includeEmpty ? GroupSelector.State.ACCEPT : GroupSelector.State.SKIP;
        }
        this.current = this.rangeFactory.getRange(this.values.longValue(), this.current);
        if (this.inSecondPass == null) {
            return GroupSelector.State.ACCEPT;
        }
        return this.inSecondPass.contains(this.current) ? GroupSelector.State.ACCEPT : GroupSelector.State.SKIP;
    }

    @Override
    public LongRange currentValue() throws IOException {
        return this.positioned ? this.current : null;
    }

    @Override
    public LongRange copyValue() throws IOException {
        return this.positioned ? new LongRange(this.current.min, this.current.max) : null;
    }

    @Override
    public void setGroups(Collection<SearchGroup<LongRange>> searchGroups) {
        this.inSecondPass = new HashSet<LongRange>();
        this.includeEmpty = false;
        for (SearchGroup<LongRange> group : searchGroups) {
            if (group.groupValue == null) {
                this.includeEmpty = true;
                continue;
            }
            this.inSecondPass.add((LongRange)group.groupValue);
        }
    }
}

