/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Collector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocValuesStats;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.LeafCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorable;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreMode;

public class DocValuesStatsCollector
implements Collector {
    private final DocValuesStats<?> stats;

    public DocValuesStatsCollector(DocValuesStats<?> stats) {
        this.stats = stats;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        boolean shouldProcess = this.stats.init(context);
        if (!shouldProcess) {
            return new LeafCollector(){

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                }

                @Override
                public void collect(int doc) throws IOException {
                    DocValuesStatsCollector.this.stats.addMissing();
                }
            };
        }
        return new LeafCollector(){

            @Override
            public void setScorer(Scorable scorer) throws IOException {
            }

            @Override
            public void collect(int doc) throws IOException {
                DocValuesStatsCollector.this.stats.accumulate(doc);
            }
        };
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }
}

