/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DisiWrapper;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DisjunctionScoreBlockBoundaryPropagator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DisjunctionScorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Weight;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.MathUtil;

final class DisjunctionMaxScorer
extends DisjunctionScorer {
    private final List<Scorer> subScorers;
    private final float tieBreakerMultiplier;
    private final DisjunctionScoreBlockBoundaryPropagator disjunctionBlockPropagator;

    DisjunctionMaxScorer(Weight weight, float tieBreakerMultiplier, List<Scorer> subScorers, ScoreMode scoreMode) throws IOException {
        super(weight, subScorers, scoreMode);
        this.subScorers = subScorers;
        this.tieBreakerMultiplier = tieBreakerMultiplier;
        if (tieBreakerMultiplier < 0.0f || tieBreakerMultiplier > 1.0f) {
            throw new IllegalArgumentException("tieBreakerMultiplier must be in [0, 1]");
        }
        this.disjunctionBlockPropagator = scoreMode == ScoreMode.TOP_SCORES ? new DisjunctionScoreBlockBoundaryPropagator(subScorers) : null;
    }

    @Override
    protected float score(DisiWrapper topList) throws IOException {
        float scoreMax = 0.0f;
        double otherScoreSum = 0.0;
        DisiWrapper w = topList;
        while (w != null) {
            float subScore = w.scorer.score();
            if (subScore >= scoreMax) {
                otherScoreSum += (double)scoreMax;
                scoreMax = subScore;
            } else {
                otherScoreSum += (double)subScore;
            }
            w = w.next;
        }
        return (float)((double)scoreMax + otherScoreSum * (double)this.tieBreakerMultiplier);
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        return this.disjunctionBlockPropagator.advanceShallow(target);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        float scoreMax = 0.0f;
        double otherScoreSum = 0.0;
        for (Scorer scorer : this.subScorers) {
            if (scorer.docID() > upTo) continue;
            float subScore = scorer.getMaxScore(upTo);
            if (subScore >= scoreMax) {
                otherScoreSum += (double)scoreMax;
                scoreMax = subScore;
                continue;
            }
            otherScoreSum += (double)subScore;
        }
        if (this.tieBreakerMultiplier == 0.0f) {
            return scoreMax;
        }
        return (float)((double)scoreMax + (otherScoreSum *= 1.0 + 2.0 * MathUtil.sumRelativeErrorBound(this.subScorers.size() - 1)) * (double)this.tieBreakerMultiplier);
    }

    @Override
    public void setMinCompetitiveScore(float minScore) throws IOException {
        this.getBlockMaxApprox().setMinCompetitiveScore(minScore);
        this.disjunctionBlockPropagator.setMinCompetitiveScore(minScore);
        if (this.tieBreakerMultiplier == 0.0f) {
            for (Scorer scorer : this.subScorers) {
                scorer.setMinCompetitiveScore(minScore);
            }
        }
    }
}

